//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ScaleNodeRelativePropertySetter_H)
#define CANDERA_ScaleNodeRelativePropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/NodeRelativePropertySetter.h>
#include <Candera/System/Mathematics/Vector3.h>

namespace Candera {

    namespace Animation {

        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /**
         * @brief A RelativePropertySetter that sets the scale, XYZ of a Node.
         *
         * The absolute scaling factor will be calculated from the initial value by multiplying with the relative one.
         */
        class ScaleNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(ScaleNodeRelativePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                /**
                 *  Constructor
                 */
                ScaleNodeRelativePropertySetter():m_scale(Vector3(1.0F, 1.0F, 1.0F)) {}

                /**
                 *  Destructor
                 */
                virtual ~ScaleNodeRelativePropertySetter() override{}

                // override (AnimationPropertySetter)
                /**
                 *  A RelativePropertySetter that sets the scale, XYZ of a Node.
                 *  @param  value   The relative value that is assigned.
                 */
                virtual void Set(const Float* value) override;

                // override (RelativePropertySetter)
                /**
                 *  Initialization of the RelativePropertySetter.
                 */
                virtual void Initialize() override;

            private:
                Vector3 m_scale;
        };

        /**
         * @brief A RelativePropertySetter that sets the scale, X of a Node.
         *
         * The absolute scaling factor will be calculated from the initial value by multiplying with the relative one.
         */
        class ScaleXNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(ScaleXNodeRelativePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                /**
                 *  Constructor
                 */
                ScaleXNodeRelativePropertySetter():m_scaleX(1.0F) {}

                /**
                 *  Destructor
                 */
                virtual ~ScaleXNodeRelativePropertySetter() override {}

                // override (AnimationPropertySetter)
                /**
                 *  A RelativePropertySetter that sets the scale, X of a Node.
                 *  @param  value   The relative value that is assigned.
                 */
                virtual void Set(const Float* value) override;

                // override (RelativePropertySetter)
                /**
                 *  Initialization of the RelativePropertySetter.
                 */
                virtual void Initialize() override;

            private:
                Float m_scaleX;
        };

        /**
         * @brief A RelativePropertySetter that sets the scale, Y of a Node.
         *
         * The absolute scaling factor will be calculated from the initial value by multiplying with the relative one.
         */
        class ScaleYNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(ScaleYNodeRelativePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                /**
                 *  Constructor
                 */
                ScaleYNodeRelativePropertySetter(): m_scaleY(1.0F) {}

                /**
                 *  Destructor
                 */
                virtual ~ScaleYNodeRelativePropertySetter() override{}

                // override (AnimationPropertySetter)
                /**
                 *  A RelativePropertySetter that sets the scale, Y of a Node.
                 *  @param  value   The resulting value that is assigned.
                 */
                virtual void Set(const Float* value) override;

                // override (RelativePropertySetter)
                /**
                 *  Initialization of the RelativePropertySetter.
                 */
                virtual void Initialize() override;
            private:
                Float m_scaleY;
        };

        /**
         * @brief A RelativePropertySetter that sets the scale, Z of a Node.
         *
         * The absolute scaling factor will be calculated from the initial value by multiplying with the relative one.
         */
        class ScaleZNodeRelativePropertySetter : public NodeRelativePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodeRelativePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(ScaleZNodeRelativePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                /**
                 *  Constructor
                 */
                ScaleZNodeRelativePropertySetter():m_scaleZ(1.0F) {}

                /**
                 *  Destructor
                 */
                ~ScaleZNodeRelativePropertySetter() {}

                // override (AnimationPropertySetter)
                /**
                 *  A RelativePropertySetter that sets the scale, Z of a Node.
                 *  @param  value   The relative value that is assigned.
                 */
                virtual void Set(const Float* value) override;

                // override (RelativePropertySetter)
                /**
                 *  Initialization of the RelativePropertySetter.
                 */
                virtual void Initialize() override;

            private:
                Float m_scaleZ;
        };

        /** @} */ // end of AnimationPropertySetters3D

    }
}
#endif
