//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ScaleNodeRelativePropertySetter.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/AnimationPropertySetters/Vector3PropertySetterUtil.h>

CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1025, Lint may be in error)
CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1703, Lint may be in error)

namespace Candera {
    namespace Animation {

        namespace {

            Vector3 ScaleV3Getter(const Node& n)
            {
                return n.GetScale();
            }

            void ScaleV3Setter(Node& n, const Vector3& v3)
            {
                n.SetScale(v3);
            }

        }

        FEATSTD_RTTI_DEFINITION(ScaleNodeRelativePropertySetter, NodeRelativePropertySetter)
        FEATSTD_RTTI_DEFINITION(ScaleXNodeRelativePropertySetter, NodeRelativePropertySetter)
        FEATSTD_RTTI_DEFINITION(ScaleYNodeRelativePropertySetter, NodeRelativePropertySetter)
        FEATSTD_RTTI_DEFINITION(ScaleZNodeRelativePropertySetter, NodeRelativePropertySetter)

        ScaleNodeRelativePropertySetter::SharedPointer ScaleNodeRelativePropertySetter::Create()
        {
            return ScaleNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(ScaleNodeRelativePropertySetter));
        }

        void ScaleNodeRelativePropertySetter::Set(const Float* value)
        {
            FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: Only getter, no side effect")
            Float resultingValue[3] = { value[0] * m_scale.GetX(),
                                        value[1]* m_scale.GetY(),
                                        value[2]* m_scale.GetZ()
                                      };

            SetVector3Property<ScaleV3Getter, ScaleV3Setter, XYZ_AxisSelector>(GetNode(), &resultingValue[0]);
        }

        void ScaleNodeRelativePropertySetter::Initialize()
        {
            m_scale = (GetNode() != 0) ? GetNode()->GetScale() : Vector3(1.0F, 1.0F, 1.0F);
        }

        ScaleXNodeRelativePropertySetter::SharedPointer ScaleXNodeRelativePropertySetter::Create()
        {
            return ScaleXNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(ScaleXNodeRelativePropertySetter));
        }

        void ScaleXNodeRelativePropertySetter::Set(const Float* value)
        {
            Float resultingValue = value[0] * m_scaleX;
            SetVector3Property<ScaleV3Getter, ScaleV3Setter, X_AxisSelector>(GetNode(), &resultingValue);
        }

        void ScaleXNodeRelativePropertySetter::Initialize()
        {
            m_scaleX = (GetNode() != 0) ? GetNode()->GetScale().GetX() : 1.0F;
        }

        ScaleYNodeRelativePropertySetter::SharedPointer ScaleYNodeRelativePropertySetter::Create()
        {
            return ScaleYNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(ScaleYNodeRelativePropertySetter));
        }

        void ScaleYNodeRelativePropertySetter::Set(const Float* value)
        {
            Float resultingValue = value[0] * m_scaleY;
            SetVector3Property<ScaleV3Getter, ScaleV3Setter, Y_AxisSelector>(GetNode(), &resultingValue);
        }

        void ScaleYNodeRelativePropertySetter::Initialize()
        {
            m_scaleY = (GetNode() != 0) ? GetNode()->GetScale().GetY() : 1.0F;
        }

        ScaleZNodeRelativePropertySetter::SharedPointer ScaleZNodeRelativePropertySetter::Create()
        {
            return ScaleZNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(ScaleZNodeRelativePropertySetter));
        }

        void ScaleZNodeRelativePropertySetter::Set(const Float* value)
        {
            Float resultingValue = value[0] * m_scaleZ;
            SetVector3Property<ScaleV3Getter, ScaleV3Setter, Z_AxisSelector>(GetNode(), &resultingValue);
        }

        void ScaleZNodeRelativePropertySetter::Initialize()
        {
            m_scaleZ = (GetNode() != 0) ? GetNode()->GetScale().GetZ() : 1.0F;
        }

    }
}
