//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ScaleNodePropertySetter.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/AnimationPropertySetters/Vector3PropertySetterUtil.h>

CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1025, Lint may be in error)
CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1703, Lint may be in error)

namespace Candera {
    namespace Animation {

namespace {

    Vector3 ScaleV3Getter(const Node& n)
    {
        return n.GetScale();
    }

    void ScaleV3Setter(Node& n, const Vector3& v3)
    {
        n.SetScale(v3);
    }

}

FEATSTD_RTTI_DEFINITION(ScaleNodePropertySetter, NodePropertySetter)
FEATSTD_RTTI_DEFINITION(ScaleXNodePropertySetter, NodePropertySetter)
FEATSTD_RTTI_DEFINITION(ScaleYNodePropertySetter, NodePropertySetter)
FEATSTD_RTTI_DEFINITION(ScaleZNodePropertySetter, NodePropertySetter)

ScaleNodePropertySetter::SharedPointer ScaleNodePropertySetter::Create()
{
    return ScaleNodePropertySetter::SharedPointer(CANDERA_NEW(ScaleNodePropertySetter));
}

void ScaleNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<ScaleV3Getter, ScaleV3Setter, XYZ_AxisSelector>(GetNode(), value);
}

ScaleXNodePropertySetter::SharedPointer ScaleXNodePropertySetter::Create()
{
    return ScaleXNodePropertySetter::SharedPointer(CANDERA_NEW(ScaleXNodePropertySetter));
}

void ScaleXNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<ScaleV3Getter, ScaleV3Setter, X_AxisSelector>(GetNode(), value);
}

ScaleYNodePropertySetter::SharedPointer ScaleYNodePropertySetter::Create()
{
    return ScaleYNodePropertySetter::SharedPointer(CANDERA_NEW(ScaleYNodePropertySetter));
}

void ScaleYNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<ScaleV3Getter, ScaleV3Setter, Y_AxisSelector>(GetNode(), value);
}

ScaleZNodePropertySetter::SharedPointer ScaleZNodePropertySetter::Create()
{
    return ScaleZNodePropertySetter::SharedPointer(CANDERA_NEW(ScaleZNodePropertySetter));
}

void ScaleZNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<ScaleV3Getter, ScaleV3Setter, Z_AxisSelector>(GetNode(), value);
}

    }
}
