//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "RotateNodeRelativePropertySetter.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/AnimationPropertySetters/Vector3PropertySetterUtil.h>

CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1025, Lint may be in error)
CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1703, Lint may be in error)

namespace Candera {
    namespace Animation {

        namespace {
            Vector3 RotationV3Getter(const Node& n)
            {
                return n.GetRotation();
            }

            void RotationV3Setter(Node& n, const Vector3& v3)
            {
                n.SetRotation(v3);
            }
        }

        FEATSTD_RTTI_DEFINITION(RotateNodeRelativePropertySetter, NodeRelativePropertySetter)
        FEATSTD_RTTI_DEFINITION(RotateXNodeRelativePropertySetter, NodeRelativePropertySetter)
        FEATSTD_RTTI_DEFINITION(RotateYNodeRelativePropertySetter, NodeRelativePropertySetter)
        FEATSTD_RTTI_DEFINITION(RotateZNodeRelativePropertySetter, NodeRelativePropertySetter)

        RotateNodeRelativePropertySetter::SharedPointer RotateNodeRelativePropertySetter::Create()
        {
            return RotateNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(RotateNodeRelativePropertySetter));
        }

        void RotateNodeRelativePropertySetter::Set(const Float* value)
        {
            FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: Only getter, no side effect")
            Float resultingValue[3] = { value[0] + m_rotation.GetX(),
                                        value[1] + m_rotation.GetY(),
                                        value[2] + m_rotation.GetZ()
                                      };

            SetVector3Property<RotationV3Getter, RotationV3Setter, XYZ_AxisSelector>(GetNode(), &resultingValue[0]);
        }

        void RotateNodeRelativePropertySetter::Initialize()
        {
            m_rotation = (GetNode() != 0) ? GetNode()->GetRotation() : Vector3(0.0F, 0.0F, 0.0F);
        }

        RotateXNodeRelativePropertySetter::SharedPointer RotateXNodeRelativePropertySetter::Create()
        {
            return RotateXNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(RotateXNodeRelativePropertySetter));
        }

        void RotateXNodeRelativePropertySetter::Set(const Float* value)
        {
            Float resultingValue = value[0] + m_rotationX;
            SetVector3Property<RotationV3Getter, RotationV3Setter, X_AxisSelector>(GetNode(), &resultingValue);
        }

        void RotateXNodeRelativePropertySetter::Initialize()
        {
            m_rotationX = (GetNode() != 0) ? GetNode()->GetRotation().GetX() : 0.0F;
        }

        RotateYNodeRelativePropertySetter::SharedPointer RotateYNodeRelativePropertySetter::Create()
        {
            return RotateYNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(RotateYNodeRelativePropertySetter));
        }

        void RotateYNodeRelativePropertySetter::Set(const Float* value)
        {
            Float resultingValue = value[0] + m_rotationY;
            SetVector3Property<RotationV3Getter, RotationV3Setter, Y_AxisSelector>(GetNode(), &resultingValue);
        }

        void RotateYNodeRelativePropertySetter::Initialize()
        {
            m_rotationY = (GetNode() != 0) ? GetNode()->GetRotation().GetY() : 0.0F;
        }

        RotateZNodeRelativePropertySetter::SharedPointer RotateZNodeRelativePropertySetter::Create()
        {
            return RotateZNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(RotateZNodeRelativePropertySetter));
        }

        void RotateZNodeRelativePropertySetter::Set(const Float* value)
        {
            Float resultingValue = value[0] + m_rotationZ;
            SetVector3Property<RotationV3Getter, RotationV3Setter, Z_AxisSelector>(GetNode(), &resultingValue);
        }

        void RotateZNodeRelativePropertySetter::Initialize()
        {
            m_rotationZ = (GetNode() != 0) ? GetNode()->GetRotation().GetZ() : 0.0F;
        }

    }
}
