//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_RotateNodePropertySetter_H)
#define CANDERA_RotateNodePropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/NodePropertySetter.h>

namespace Candera {

    namespace Animation {

        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /** @brief A PropertySetter that sets the rotation, XYZ of a Node. */
        class RotateNodePropertySetter : public NodePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(RotateNodePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the rotation, XYZ of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the rotation, X of a Node. */
        class RotateXNodePropertySetter : public NodePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(RotateXNodePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the rotation, X of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the rotation, Y of a Node. */
        class RotateYNodePropertySetter : public NodePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(RotateYNodePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the rotation, Y of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @brief A PropertySetter that sets the rotation, Z of a Node. */
        class RotateZNodePropertySetter : public NodePropertySetter {

            FEATSTD_TYPEDEF_BASE(NodePropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(RotateZNodePropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                // override (AnimationPropertySetter)
                /**
                 *  A PropertySetter that sets the rotation, Z of a Node.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;
        };

        /** @} */ // end of AnimationPropertySetters3D

    }
}
#endif
