//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_RenderingEnabledNodePropertySetter_H)
#define CANDERA_RenderingEnabledNodePropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/NodePropertySetter.h>

namespace Candera {

    namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */
 
/** @brief A PropertySetter that sets the "rendering enabled" property of a Node.
 * Rendering enabled is bool; it is considered true if the animated float value is > 0.5F */
class RenderingEnabledNodePropertySetter : public NodePropertySetter {

    FEATSTD_TYPEDEF_BASE(NodePropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(RenderingEnabledNodePropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the "rendering enabled" property of a Node.
     *  Rendering enabled is bool; it is considered true if the animated float value is > 0.5F
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};
 
/** @} */ // end of AnimationPropertySetters3D
 
    }
}
#endif
