//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "RenderingEnabledNodePropertySetter.h"
#include <Candera/Engine3D/Core/Node.h>

namespace Candera {
    namespace Animation {

        FEATSTD_RTTI_DEFINITION(RenderingEnabledNodePropertySetter, NodePropertySetter)

        RenderingEnabledNodePropertySetter::SharedPointer RenderingEnabledNodePropertySetter::Create()
        {
            return RenderingEnabledNodePropertySetter::SharedPointer(CANDERA_NEW(RenderingEnabledNodePropertySetter));
        }

        void RenderingEnabledNodePropertySetter::Set(const Float* value)
        {
            if (value == 0) {
                return;
            }

            Node* const n = GetNode();
            if (n == 0) {
                return;
            }

            const bool renderingEnabled = (value[0] > 0.5F);
            n->SetRenderingEnabled(renderingEnabled);
        }
    }
}
