//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_NodeRelativePropertySetter_H)
#define CANDERA_NodeRelativePropertySetter_H

#include <Candera/EngineBase/Animation/RelativePropertySetter.h>
#include <Candera/Macros.h>

namespace Candera {

class Node;

namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */
 
/** @brief A relative PropertySetter that sets properties of a Node. This is a base class.*/
class NodeRelativePropertySetter : public RelativePropertySetter {

    FEATSTD_TYPEDEF_BASE(RelativePropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(NodeRelativePropertySetter);

    /**
     *  Constructor
     */
    NodeRelativePropertySetter();

    /**
     *  Destructor
     */
    virtual ~NodeRelativePropertySetter() override;

    /**
     *  Assigns a node to the RelativePropertySetter.
     *  @param node The node that is assigned.
     */
    void SetNode(Candera::Node* node);

    /**
     *  Retrieves the current node of the RelativePropertySetter.
     *  @return The current node.
     */
    Node* GetNode();

private:
    Node* m_node;

    CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::NodeRelativePropertySetter::NodeRelativePropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
    NodeRelativePropertySetter(const NodeRelativePropertySetter&);
    NodeRelativePropertySetter& operator=(const NodeRelativePropertySetter&);
};


inline void NodeRelativePropertySetter::SetNode(Candera::Node* node)
{
    m_node = node;
}

inline Candera::Node* NodeRelativePropertySetter::GetNode()
{
    return m_node;
}
 
/** @} */ // end of AnimationPropertySetters3D

}
}
#endif
