//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "NodeBlendColorPropertySetter.h"
#include <Candera/Engine3D/Core/Appearance.h>
#include <Candera/Engine3D/Core/RenderMode.h>
#include <Candera/Engine3D/Core/Node.h>

namespace Candera {

    namespace Animation {

        void NodeBlendColorPropertySetter::Set(const Float* value)
        {
            Node* node = GetNode();
            if ((value != 0) && (node != 0)) {
                MemoryManagement::SharedPointer<Appearance> appearance = GetAppearance();
                if (appearance == 0) {
                    appearance = node->GetAppearance();
                }
                if (appearance != 0) {
                    MemoryManagement::SharedPointer<RenderMode> rm = appearance->GetRenderMode();
                    if (rm != 0) {
                        rm->SetBlendColor(Color(value[0], value[1], value[2], value[3]));
                    }
                }
            }
        }
    }
} // namespace Candera
