//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_NodeAppearancePropertySetter_H)
#define CANDERA_NodeAppearancePropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/Engine3D/Core/Appearance.h>
#include <Candera/Engine3D/AnimationPropertySetters/NodePropertySetter.h>
#include <Candera/Macros.h>

namespace Candera {

namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

/** @brief A PropertySetter that sets properties of an appearance and a node. Derived from NodePropertySetter. */
class NodeAppearancePropertySetter : public NodePropertySetter {

    FEATSTD_TYPEDEF_BASE(NodePropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    /**
     *  Constructor
     */
    NodeAppearancePropertySetter();

    /**
     *  Destructor
     */
    virtual ~NodeAppearancePropertySetter() override;

    /**
     *  Appearance containing properties to set animated values on. Per default appearance of node is
     *  used, if appearance is set then this one is used instead. This is needed to support setting properties
     *  of MultiPassAppearances.
     *  @param appearance Appearance to use if other appearance then the node's property
     *                    shall be used.
     */
    void SetAppearance(MemoryManagement::SharedPointer<Appearance> appearance) { m_appearance = appearance; }

    /**
     *  Appearance containing properties to set animated values on. Per default appearance of node is
     *  used, if appearance is set then this one is used instead. This is needed to support setting properties
     *  of MultiPassAppearances.
     *  @return The current appearance.
     */
    MemoryManagement::SharedPointer<Appearance> GetAppearance() const { return m_appearance; }

private:
    MemoryManagement::SharedPointer<Appearance> m_appearance;

    CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::NodeAppearancePropertySetter::NodeAppearancePropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
    NodeAppearancePropertySetter(const NodeAppearancePropertySetter&);
    NodeAppearancePropertySetter& operator=(const NodeAppearancePropertySetter&);
};



/** @} */ // end of AnimationPropertySetters3D

}
}
#endif
