//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_MorphWeightPropertySetter_H)
#define CANDERA_MorphWeightPropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>

namespace Candera {
    class MorphingMesh;

    namespace Animation {
        /** @addtogroup AnimationPropertySetters3D
         *  @{
         */

        /** @brief A PropertySetter that sets one morph weight of a MorphingMesh. */
        class MorphWeightPropertySetter : public AnimationPropertySetter {
                FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(MorphWeightPropertySetter);

                /**
                 *  Constructor
                 */
                MorphWeightPropertySetter();

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

                /**
                 *  Assigns a morphing mesh to the PropertySetter.
                 *  @param morphingMesh The morphing mesh that is assigned.
                 */
                void SetMorphingMesh(MorphingMesh* morphingMesh);

                /**
                 *  Retrieves the current morphing mesh of the PropertySetter.
                 *  @return The current morphing mesh.
                 */
                const MorphingMesh* GetMorphingMesh() const;

                /**
                 *  Assigns the weight index.
                 *  @param index The index that is assigned.
                 */
                void SetWeightIndex(Int32 index);

                /**
                 *  Retrieves the current weight index of the PropertySetter.
                 *  @return The current weight index.
                 */
                Int32 GetWeightIndex() const;

                // override (AnimationPropertySetter)
                /**
                 *  Sets the value.
                 *  @param value The value that is assigned.
                 */
                virtual void Set(const Float* value) override;

            private:
                Int32 m_weightIndex;
                MorphingMesh* m_MorphingMesh;

                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::MorphWeightPropertySetter::MorphWeightPropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
                MorphWeightPropertySetter(const MorphWeightPropertySetter&);
                MorphWeightPropertySetter& operator=(const MorphWeightPropertySetter&);
        };

        /** @brief A PropertySetter that sets all morph weights of a MorphingMesh. */
        class AllMorphWeightsPropertySetter : public AnimationPropertySetter {
                FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

            public:
                FEATSTD_RTTI_DECLARATION();

                FEATSTD_TYPEDEF_SHARED_POINTER(AllMorphWeightsPropertySetter);

                FEATSTD_SHARED_POINTER_CREATE_DECLARATION();
                AllMorphWeightsPropertySetter();

                void SetMorphingMesh(MorphingMesh* morphingMesh);
                const MorphingMesh* GetMorphingMesh() const;

                void SetNumberOfWeights(Int32 numberOfWeights);
                Int32 GetNumberOfWeights() const;

                // override (AnimationPropertySetter)
                virtual void Set(const Float* value) override;

            private:
                Int32 m_numberOfWeights;
                MorphingMesh* m_MorphingMesh;

                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::AllMorphWeightsPropertySetter::AllMorphWeightsPropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
                AllMorphWeightsPropertySetter(const AllMorphWeightsPropertySetter&);
                AllMorphWeightsPropertySetter& operator=(const AllMorphWeightsPropertySetter&);
        };

        /** @} */ // end of AnimationPropertySetters3D
    }
}
#endif
