//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MorphWeightPropertySetter.h"
#include <Candera/Engine3D/Core/MorphingMesh.h>

namespace Candera {
    namespace Animation {

        FEATSTD_RTTI_DEFINITION(MorphWeightPropertySetter, AnimationPropertySetter)
        FEATSTD_RTTI_DEFINITION(AllMorphWeightsPropertySetter, AnimationPropertySetter)

        MorphWeightPropertySetter::MorphWeightPropertySetter() :
            Base(),
            m_weightIndex(0),
            m_MorphingMesh(0)
        {
        }

        MorphWeightPropertySetter::SharedPointer MorphWeightPropertySetter::Create()
        {
            return MorphWeightPropertySetter::SharedPointer(CANDERA_NEW(MorphWeightPropertySetter));
        }

        void MorphWeightPropertySetter::SetMorphingMesh(MorphingMesh* morphingMesh)
        {
            m_MorphingMesh = morphingMesh;
        }

        const MorphingMesh* MorphWeightPropertySetter::GetMorphingMesh() const
        {
            return m_MorphingMesh;
        }

        void MorphWeightPropertySetter::SetWeightIndex(Int32 index)
        {
            m_weightIndex = index;
        }

        Int32 MorphWeightPropertySetter::GetWeightIndex() const
        {
            return m_weightIndex;
        }

        void MorphWeightPropertySetter::Set(const Float* value)
        {
            if (value == 0) {
                return;
            }

            MorphingMesh* const moMesh = m_MorphingMesh;
            if (moMesh == 0) {
                return;
            }

            const Float weight = value[0];
            moMesh->SetMorphWeight(m_weightIndex, weight);
        }

        AllMorphWeightsPropertySetter::AllMorphWeightsPropertySetter() :
            Base(),
            m_numberOfWeights(0),
            m_MorphingMesh(0)
        {
        }

        AllMorphWeightsPropertySetter::SharedPointer AllMorphWeightsPropertySetter::Create()
        {
            return AllMorphWeightsPropertySetter::SharedPointer(CANDERA_NEW(AllMorphWeightsPropertySetter));
        }

        void AllMorphWeightsPropertySetter::SetMorphingMesh(MorphingMesh* morphingMesh)
        {
            m_MorphingMesh = morphingMesh;
        }

        const MorphingMesh* AllMorphWeightsPropertySetter::GetMorphingMesh() const
        {
            return m_MorphingMesh;
        }

        void AllMorphWeightsPropertySetter::SetNumberOfWeights(Int32 numberOfWeights)
        {
            m_numberOfWeights = numberOfWeights;
        }

        Int32 AllMorphWeightsPropertySetter::GetNumberOfWeights() const
        {
            return m_numberOfWeights;
        }

        void AllMorphWeightsPropertySetter::Set(const Float* value)
        {
            if (value == 0) {
                return;
            }

            MorphingMesh* const moMesh = m_MorphingMesh;
            if (moMesh == 0) {
                return;
            }

            for (Int32 i = 0; i < m_numberOfWeights; ++i) {
                const Float weight = value[i];
                moMesh->SetMorphWeight(i, weight);
            }
        }
    }
}
