//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_MaterialAmbientPropertySetter_H)
#define CANDERA_MaterialAmbientPropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/MaterialPropertySetter.h>

namespace Candera {

    namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

/** @brief A PropertySetter that sets the ambient, RGB part of the Material of a Node. */
class MaterialAmbientPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialAmbientPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the ambient, RGB part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the ambient, R part of the Material of a Node. */
class MaterialAmbientRPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialAmbientRPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the ambient, R part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the ambient, G part of the Material of a Node. */
class MaterialAmbientGPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialAmbientGPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the ambient, G part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the ambient, B part of the Material of a Node. */
class MaterialAmbientBPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialAmbientBPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the ambient, B part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};


/** @brief A PropertySetter that sets the Diffuse, RGB part of the Material of a Node. */
class MaterialDiffusePropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialDiffusePropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Diffuse, RGB part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Diffuse, R part of the Material of a Node. */
class MaterialDiffuseRPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialDiffuseRPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Diffuse, R part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Diffuse, G part of the Material of a Node. */
class MaterialDiffuseGPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialDiffuseGPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Diffuse, G part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Diffuse, A part of the Material of a Node. */
class MaterialDiffuseAPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Diffuse, A part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Diffuse, B part of the Material of a Node. */
class MaterialDiffuseBPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialDiffuseBPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Diffuse, B part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};


/** @brief A PropertySetter that sets the Emissive, RGB part of the Material of a Node. */
class MaterialEmissivePropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialEmissivePropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Emissive, RGB part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Emissive, R part of the Material of a Node. */
class MaterialEmissiveRPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialEmissiveRPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Emissive, R part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Emissive, G part of the Material of a Node. */
class MaterialEmissiveGPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialEmissiveGPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Emissive, G part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Emissive, B part of the Material of a Node. */
class MaterialEmissiveBPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialEmissiveBPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Emissive, B part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};


/** @brief A PropertySetter that sets the Specular, RGB part of the Material of a Node. */
class MaterialSpecularPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialSpecularPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Specular, RGB part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Specular, R part of the Material of a Node. */
class MaterialSpecularRPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialSpecularRPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Specular, R part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Specular, G part of the Material of a Node. */
class MaterialSpecularGPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialSpecularGPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Specular, G part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Specular, B part of the Material of a Node. */
class MaterialSpecularBPropertySetter : public MaterialPropertySetter {

    FEATSTD_TYPEDEF_BASE(MaterialPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(MaterialSpecularBPropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Specular, B part of the Material of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @} */ // end of AnimationPropertySetters3D

    }
}
#endif
