//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MaterialColorPropertySetter.h"
#include <Candera/Engine3D/Core/Material.h>
#include <Candera/Engine3D/AnimationPropertySetters/ColorPropertySetterUtil.h>

CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1025, Lint may be in error)
CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1703, Lint may be in error)

namespace Candera {

    namespace Animation {

        namespace {
            Color GetAmbient(const Material& mat)
            {
                return mat.GetAmbient();
            }

            void SetAmbient(Material& mat, const Color& col)
            {
                mat.SetAmbient(col);
            }

            Color GetDiffuse(const Material& mat)
            {
                return mat.GetDiffuse();
            }

            void SetDiffuse(Material& mat, const Color& col)
            {
                mat.SetDiffuse(col);
            }

            Color GetEmissive(const Material& mat)
            {
                return mat.GetEmissive();
            }

            void SetEmissive(Material& mat, const Color& col)
            {
                mat.SetEmissive(col);
            }

            Color GetSpecular(const Material& mat)
            {
                return mat.GetSpecular();
            }

            void SetSpecular(Material& mat, const Color& col)
            {
                mat.SetSpecular(col);
            }
        }

        FEATSTD_RTTI_DEFINITION(MaterialAmbientPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialAmbientRPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialAmbientGPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialAmbientBPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialDiffusePropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialDiffuseRPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialDiffuseGPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialDiffuseBPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialDiffuseAPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialEmissivePropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialEmissiveRPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialEmissiveGPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialEmissiveBPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialSpecularPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialSpecularRPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialSpecularGPropertySetter, MaterialPropertySetter)
        FEATSTD_RTTI_DEFINITION(MaterialSpecularBPropertySetter, MaterialPropertySetter)

        MaterialAmbientPropertySetter::SharedPointer MaterialAmbientPropertySetter::Create()
        {
            return MaterialAmbientPropertySetter::SharedPointer(CANDERA_NEW(MaterialAmbientPropertySetter));
        }

        void MaterialAmbientPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetAmbient, SetAmbient, RGB_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialAmbientRPropertySetter::SharedPointer MaterialAmbientRPropertySetter::Create()
        {
            return MaterialAmbientRPropertySetter::SharedPointer(CANDERA_NEW(MaterialAmbientRPropertySetter));
        }

        void MaterialAmbientRPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetAmbient, SetAmbient, R_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialAmbientGPropertySetter::SharedPointer MaterialAmbientGPropertySetter::Create()
        {
            return MaterialAmbientGPropertySetter::SharedPointer(CANDERA_NEW(MaterialAmbientGPropertySetter));
        }

        void MaterialAmbientGPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetAmbient, SetAmbient, G_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialAmbientBPropertySetter::SharedPointer MaterialAmbientBPropertySetter::Create()
        {
            return MaterialAmbientBPropertySetter::SharedPointer(CANDERA_NEW(MaterialAmbientBPropertySetter));
        }

        void MaterialAmbientBPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetAmbient, SetAmbient, B_ColorComponentSelector>(GetMaterial(), value);
        }


        MaterialDiffusePropertySetter::SharedPointer MaterialDiffusePropertySetter::Create()
        {
            return MaterialDiffusePropertySetter::SharedPointer(CANDERA_NEW(MaterialDiffusePropertySetter));
        }

        void MaterialDiffusePropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetDiffuse, SetDiffuse, RGB_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialDiffuseRPropertySetter::SharedPointer MaterialDiffuseRPropertySetter::Create()
        {
            return MaterialDiffuseRPropertySetter::SharedPointer(CANDERA_NEW(MaterialDiffuseRPropertySetter));
        }

        void MaterialDiffuseRPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetDiffuse, SetDiffuse, R_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialDiffuseGPropertySetter::SharedPointer MaterialDiffuseGPropertySetter::Create()
        {
            return MaterialDiffuseGPropertySetter::SharedPointer(CANDERA_NEW(MaterialDiffuseGPropertySetter));
        }

        void MaterialDiffuseGPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetDiffuse, SetDiffuse, G_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialDiffuseBPropertySetter::SharedPointer MaterialDiffuseBPropertySetter::Create()
        {
            return MaterialDiffuseBPropertySetter::SharedPointer(CANDERA_NEW(MaterialDiffuseBPropertySetter));
        }

        void MaterialDiffuseBPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetDiffuse, SetDiffuse, B_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialDiffuseAPropertySetter::SharedPointer MaterialDiffuseAPropertySetter::Create()
        {
            return MaterialDiffuseAPropertySetter::SharedPointer(CANDERA_NEW(MaterialDiffuseAPropertySetter));
        }

        void MaterialDiffuseAPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetDiffuse, SetDiffuse, A_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialEmissivePropertySetter::SharedPointer MaterialEmissivePropertySetter::Create()
        {
            return MaterialEmissivePropertySetter::SharedPointer(CANDERA_NEW(MaterialEmissivePropertySetter));
        }

        void MaterialEmissivePropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetEmissive, SetEmissive, RGB_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialEmissiveRPropertySetter::SharedPointer MaterialEmissiveRPropertySetter::Create()
        {
            return MaterialEmissiveRPropertySetter::SharedPointer(CANDERA_NEW(MaterialEmissiveRPropertySetter));
        }

        void MaterialEmissiveRPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetEmissive, SetEmissive, R_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialEmissiveGPropertySetter::SharedPointer MaterialEmissiveGPropertySetter::Create()
        {
            return MaterialEmissiveGPropertySetter::SharedPointer(CANDERA_NEW(MaterialEmissiveGPropertySetter));
        }

        void MaterialEmissiveGPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetEmissive, SetEmissive, G_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialEmissiveBPropertySetter::SharedPointer MaterialEmissiveBPropertySetter::Create()
        {
            return MaterialEmissiveBPropertySetter::SharedPointer(CANDERA_NEW(MaterialEmissiveBPropertySetter));
        }

        void MaterialEmissiveBPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetEmissive, SetEmissive, B_ColorComponentSelector>(GetMaterial(), value);
        }


        MaterialSpecularPropertySetter::SharedPointer MaterialSpecularPropertySetter::Create()
        {
            return MaterialSpecularPropertySetter::SharedPointer(CANDERA_NEW(MaterialSpecularPropertySetter));
        }

        void MaterialSpecularPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetSpecular, SetSpecular, RGB_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialSpecularRPropertySetter::SharedPointer MaterialSpecularRPropertySetter::Create()
        {
            return MaterialSpecularRPropertySetter::SharedPointer(CANDERA_NEW(MaterialSpecularRPropertySetter));
        }

        void MaterialSpecularRPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetSpecular, SetSpecular, R_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialSpecularGPropertySetter::SharedPointer MaterialSpecularGPropertySetter::Create()
        {
            return MaterialSpecularGPropertySetter::SharedPointer(CANDERA_NEW(MaterialSpecularGPropertySetter));
        }

        void MaterialSpecularGPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetSpecular, SetSpecular, G_ColorComponentSelector>(GetMaterial(), value);
        }

        MaterialSpecularBPropertySetter::SharedPointer MaterialSpecularBPropertySetter::Create()
        {
            return MaterialSpecularBPropertySetter::SharedPointer(CANDERA_NEW(MaterialSpecularBPropertySetter));
        }

        void MaterialSpecularBPropertySetter::Set(const Float* value)
        {
            SetMaterialColorProperty<GetSpecular, SetSpecular, B_ColorComponentSelector>(GetMaterial(), value);
        }
    }
}
