//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_LightPropertySetter_H)
#define CANDERA_LightPropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/Macros.h>

namespace Candera {

class Light;

namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

/** @brief A PropertySetter that sets properties of a Light. This is a base class.*/
class LightPropertySetter : public AnimationPropertySetter {

    FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(LightPropertySetter);

    /**
     *  Constructor
     */
    LightPropertySetter();

    /**
     *  Destructor
     */
    virtual ~LightPropertySetter() override;

    /**
     *  Assigns a light to the PropertySetter.
     *  @param light The light that is assigned.
     */
    void SetLight(Candera::Light* light);

    /**
     *  Retrieves the current light of the PropertySetter.
     *  @return A Pointer to the current light.
     */
    Light* GetLight();

private:
    Light* m_light;

    CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::Animation::LightPropertySetter::LightPropertySetter, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
    LightPropertySetter(const LightPropertySetter&);
    LightPropertySetter& operator=(const LightPropertySetter&);
};


inline void LightPropertySetter::SetLight(Candera::Light* light)
{
    m_light = light;
}

inline Candera::Light* LightPropertySetter::GetLight()
{
    return m_light;
}

/** @} */ // end of AnimationPropertySetters3D

}
}
#endif
