//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ColorPropertySetterUtil_H)
#define CANDERA_ColorPropertySetterUtil_H

#include <Candera/Environment.h>
#include <Candera/Engine3D/Core/Appearance.h>
#include <Candera/Engine3D/Core/Material.h>
#include <Candera/Engine3D/Core/Node.h>

namespace Candera {
    class Light;
    namespace Animation {

 /** @addtogroup AnimationPropertySetters3D
 *  @{
 */

    typedef Color (*ColorGetter)(const Node&);
    typedef void (*ColorSetter)(Node&, const Color&);
    typedef Color (*MaterialColorGetter)(const Material&);
    typedef void (*MaterialColorSetter)(Material&, const Color&);
    typedef Color (*LightColorGetter)(const Light&);
    typedef void (*LightColorSetter)(Light&, const Color&);

    typedef void (*ColorComponentSelector)(const Float* value, Color& destColor);
    inline void R_ColorComponentSelector(const Float* value, Color& destColor)
    {
        destColor.SetRed(value[0]);
    }
    inline void G_ColorComponentSelector(const Float* value, Color& destColor)
    {
        destColor.SetGreen(value[0]);
    }
    inline void B_ColorComponentSelector(const Float* value, Color& destColor)
    {
        destColor.SetBlue(value[0]);
    }
    inline void A_ColorComponentSelector(const Float* value, Color& destColor)
    {
        destColor.SetAlpha(value[0]);
    }
    inline void RGB_ColorComponentSelector(const Float* value, Color& destColor)
    {
        destColor.SetRed(value[0]);
        destColor.SetGreen(value[1]);
        destColor.SetBlue(value[2]);
    }


    template<MaterialColorGetter matColorGetter, MaterialColorSetter matColorSetter, ColorComponentSelector componentSel>
    void SetMaterialColorProperty(MemoryManagement::SharedPointer<Material> mat, const Float* value)
    {
        if (value == 0) {
            return;
        }

        if (mat.PointsToNull()) {
            return;
        }

        Color c = matColorGetter(*mat);
        componentSel(value, c);
        matColorSetter(*mat, c);
    }

    template<LightColorGetter lightColorGetter, LightColorSetter lightColorSetter, ColorComponentSelector componentSel>
    void SetLightColorProperty(Light* light, const Float* value)
    {
        if (value == 0) {
            return;
        }

        if (light == 0) {
            return;
        }

        Color c = lightColorGetter(*light);
        componentSel(value, c);
        lightColorSetter(*light, c);
    }
/** @} */ // end of AnimationPropertySetters3D
    } // namespace Animation

} // namespace Candera

#endif
