//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CanvasVertexRectanglePropertySetter_H)
#define CANDERA_CanvasVertexRectanglePropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/BaseCanvasRenderablePropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

    /** 
     * @brief A PropertySetter that sets the "VertexRectangle" property for a CanvasRenderable.
     */
    class CanvasVertexRectanglePropertySetter : public BaseCanvasRenderablePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CanvasVertexRectanglePropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
         * Sets the "VertexRectangle" property of the CanvasRenderable object.
         *
         * @param value - pointer to an array of 4 float values for the VertexRectangle rectangle.
         */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CanvasVertexRectanglePropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Left value for the "VertexRectangle" property of a CanvasRenderable.
    */
    class CanvasVertexRectangleLeftPropertySetter : public BaseCanvasRenderablePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CanvasVertexRectangleLeftPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Left value for the "VertexRectangle" property of a CanvasRenderable object.
        *
        * @param value - Left value for the VertexRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CanvasVertexRectangleLeftPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Top value for the "VertexRectangle" property of a CanvasRenderable.
    */
    class CanvasVertexRectangleTopPropertySetter : public BaseCanvasRenderablePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CanvasVertexRectangleTopPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Top value for the "VertexRectangle" property of the CanvasRenderable object.
        *
        * @param value - Top value for the VertexRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CanvasVertexRectangleTopPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Width value for the "VertexRectangle" property of a CanvasRenderable.
    */
    class CanvasVertexRectangleWidthPropertySetter : public BaseCanvasRenderablePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CanvasVertexRectangleWidthPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets Width value for the "VertexRectangle" property of the CanvasRenderable object.
        *
        * @param value - Width value for the VertexRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CanvasVertexRectangleWidthPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Height value for the "VertexRectangle" property of a CanvasRenderable.
    */
    class CanvasVertexRectangleHeightPropertySetter : public BaseCanvasRenderablePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CanvasVertexRectangleHeightPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Height value for the "VertexRectangle" property of the CanvasRenderable object.
        *
        * @param value - Height value for the VertexRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CanvasVertexRectangleHeightPropertySetter);
    };

 /** @} */ // end of BaseCanvasRenderablePropertySetters
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_CanvasVertexRectanglePropertySetter_H
