//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CanvasVertexRectanglePropertySetter.h"
#include <Candera/Engine3D/Canvas/CanvasRenderable.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(CanvasVertexRectanglePropertySetter, BaseCanvasRenderablePropertySetter)
    FEATSTD_RTTI_DEFINITION(CanvasVertexRectangleLeftPropertySetter, BaseCanvasRenderablePropertySetter)
    FEATSTD_RTTI_DEFINITION(CanvasVertexRectangleTopPropertySetter, BaseCanvasRenderablePropertySetter)
    FEATSTD_RTTI_DEFINITION(CanvasVertexRectangleWidthPropertySetter, BaseCanvasRenderablePropertySetter)
    FEATSTD_RTTI_DEFINITION(CanvasVertexRectangleHeightPropertySetter, BaseCanvasRenderablePropertySetter)


    /******************************************************************************
    *  CanvasVertexRectanglePropertySetter method definitions
    ******************************************************************************/
    void CanvasVertexRectanglePropertySetter::Set(const Float* value)
    {
        CanvasRenderable* canvas = GetCanvasRenderable();
        if ((0 == value) || (0 == canvas)) {
            return;
        }

        canvas->SetVertexRectangle(Rectangle(value[0], value[1], value[2], value[3]));
    }
    
    CanvasVertexRectanglePropertySetter::SharedPointer CanvasVertexRectanglePropertySetter::Create()
    {
        return CanvasVertexRectanglePropertySetter::SharedPointer(CANDERA_NEW(CanvasVertexRectanglePropertySetter));
    }

    /******************************************************************************
    *  CanvasVertexRectangleLeftPropertySetter method definitions
    ******************************************************************************/
    void CanvasVertexRectangleLeftPropertySetter::Set(const Float* value)
    {
        CanvasRenderable* canvas = GetCanvasRenderable();
        if ((0 == value) || (0 == canvas)) {
            return;
        }

        Rectangle rect = canvas->GetVertexRectangle();
        rect.SetLeft(*value);
        canvas->SetVertexRectangle(rect);
    }

    CanvasVertexRectangleLeftPropertySetter::SharedPointer CanvasVertexRectangleLeftPropertySetter::Create()
    {
        return CanvasVertexRectangleLeftPropertySetter::SharedPointer(CANDERA_NEW(CanvasVertexRectangleLeftPropertySetter));
    }

    /******************************************************************************
    *  CanvasVertexRectangleTopPropertySetter method definitions
    ******************************************************************************/
    void CanvasVertexRectangleTopPropertySetter::Set(const Float* value)
    {
        CanvasRenderable* canvas = GetCanvasRenderable();
        if ((0 == value) || (0 == canvas)) {
            return;
        }

        Rectangle rect = canvas->GetVertexRectangle();
        rect.SetTop(*value);
        canvas->SetVertexRectangle(rect);
    }

    CanvasVertexRectangleTopPropertySetter::SharedPointer CanvasVertexRectangleTopPropertySetter::Create()
    {
        return CanvasVertexRectangleTopPropertySetter::SharedPointer(CANDERA_NEW(CanvasVertexRectangleTopPropertySetter));
    }

    /******************************************************************************
    *  CanvasVertexRectangleWidthPropertySetter method definitions
    ******************************************************************************/
    void CanvasVertexRectangleWidthPropertySetter::Set(const Float* value)
    {
        CanvasRenderable* canvas = GetCanvasRenderable();
        if ((0 == value) || (0 == canvas)) {
            return;
        }

        Rectangle rect = canvas->GetVertexRectangle();
        rect.SetWidth(*value);
        canvas->SetVertexRectangle(rect);
    }

    CanvasVertexRectangleWidthPropertySetter::SharedPointer CanvasVertexRectangleWidthPropertySetter::Create()
    {
        return CanvasVertexRectangleWidthPropertySetter::SharedPointer(CANDERA_NEW(CanvasVertexRectangleWidthPropertySetter));
    }

    /******************************************************************************
    *  CanvasVertexRectangleHeightPropertySetter method definitions
    ******************************************************************************/
    void CanvasVertexRectangleHeightPropertySetter::Set(const Float* value)
    {
        CanvasRenderable* canvas = GetCanvasRenderable();
        if ((0 == value) || (0 == canvas)) {
            return;
        }

        Rectangle rect = canvas->GetVertexRectangle();
        rect.SetHeight(*value);
        canvas->SetVertexRectangle(rect);
    }

    CanvasVertexRectangleHeightPropertySetter::SharedPointer CanvasVertexRectangleHeightPropertySetter::Create()
    {
        return CanvasVertexRectangleHeightPropertySetter::SharedPointer(CANDERA_NEW(CanvasVertexRectangleHeightPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
