//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CameraScissorRectanglePropertySetter_H)
#define CANDERA_CameraScissorRectanglePropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/BaseCameraPropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /** 
     * @brief A PropertySetter that sets the "ScissorRectangle" property of a Camera.
     */
    class CameraScissorRectanglePropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraScissorRectanglePropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
         * Sets the "ScissorRectangle" property of the Camera object.
         *
         * @param value - pointer to an array of 4 float values for the ScissorRectangle rectangle.
         */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraScissorRectanglePropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Left value for the "ScissorRectangle" property of a Camera.
    */
    class CameraScissorRectangleLeftPropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraScissorRectangleLeftPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Left value for the "ScissorRectangle" property of a Camera.
        *
        * @param value - Left value for the ScissorRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraScissorRectangleLeftPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Top value for the "ScissorRectangle" property of a Camera.
    */
    class CameraScissorRectangleTopPropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraScissorRectangleTopPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Top value for the "ScissorRectangle" property of the Camera object.
        *
        * @param value - Top value for the ScissorRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraScissorRectangleTopPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Width value for the "ScissorRectangle" property of a Camera.
    */
    class CameraScissorRectangleWidthPropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraScissorRectangleWidthPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the width value for the "ScissorRectangle" property of the Camera object.
        *
        * @param value - Width value for the ScissorRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraScissorRectangleWidthPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Height value for the "ScissorRectangle" property of a Camera.
    */
    class CameraScissorRectangleHeightPropertySetter : public BaseCameraPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(CameraScissorRectangleHeightPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Height value for the ScissorRectangle property of the Camera object.
        *
        * @param value - Height value for the ScissorRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(CameraScissorRectangleHeightPropertySetter);
    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_CameraScissorRectanglePropertySetter_H
