//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CameraScissorRectanglePropertySetter.h"
#include <Candera/Engine3D/Core/Camera.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(CameraScissorRectanglePropertySetter, BaseCameraPropertySetter)
    FEATSTD_RTTI_DEFINITION(CameraScissorRectangleLeftPropertySetter, BaseCameraPropertySetter)
    FEATSTD_RTTI_DEFINITION(CameraScissorRectangleTopPropertySetter, BaseCameraPropertySetter)
    FEATSTD_RTTI_DEFINITION(CameraScissorRectangleWidthPropertySetter, BaseCameraPropertySetter)
    FEATSTD_RTTI_DEFINITION(CameraScissorRectangleHeightPropertySetter, BaseCameraPropertySetter)


    /******************************************************************************
    *  CameraScissorRectanglePropertySetter method definitions
    ******************************************************************************/
    void CameraScissorRectanglePropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }
        camera->SetScissorRectangle(Rectangle(value[0], value[1], value[2], value[3]));
    }
    
    CameraScissorRectanglePropertySetter::SharedPointer CameraScissorRectanglePropertySetter::Create()
    {
        return CameraScissorRectanglePropertySetter::SharedPointer(CANDERA_NEW(CameraScissorRectanglePropertySetter));
    }

    /******************************************************************************
    *  CameraScissorRectangleLeftPropertySetter method definitions
    ******************************************************************************/
    void CameraScissorRectangleLeftPropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetScissorRectangle();
        rect.SetLeft(*value);
        camera->SetScissorRectangle(rect);
    }

    CameraScissorRectangleLeftPropertySetter::SharedPointer CameraScissorRectangleLeftPropertySetter::Create()
    {
        return CameraScissorRectangleLeftPropertySetter::SharedPointer(CANDERA_NEW(CameraScissorRectangleLeftPropertySetter));
    }

    /******************************************************************************
    *  CameraScissorRectangleTopPropertySetter method definitions
    ******************************************************************************/
    void CameraScissorRectangleTopPropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }
        Rectangle rect = camera->GetScissorRectangle();
        rect.SetTop(*value);
        camera->SetScissorRectangle(rect);
    }

    CameraScissorRectangleTopPropertySetter::SharedPointer CameraScissorRectangleTopPropertySetter::Create()
    {
        return CameraScissorRectangleTopPropertySetter::SharedPointer(CANDERA_NEW(CameraScissorRectangleTopPropertySetter));
    }

    /******************************************************************************
    *  CameraScissorRectangleWidthPropertySetter method definitions
    ******************************************************************************/
    void CameraScissorRectangleWidthPropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }
        Rectangle rect = camera->GetScissorRectangle();
        rect.SetWidth(*value);
        camera->SetScissorRectangle(rect);
    }

    CameraScissorRectangleWidthPropertySetter::SharedPointer CameraScissorRectangleWidthPropertySetter::Create()
    {
        return CameraScissorRectangleWidthPropertySetter::SharedPointer(CANDERA_NEW(CameraScissorRectangleWidthPropertySetter));
    }

    /******************************************************************************
    *  CameraScissorRectangleHeightPropertySetter method definitions
    ******************************************************************************/
    void CameraScissorRectangleHeightPropertySetter::Set(const Float* value)
    {
        Camera* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }
        Rectangle rect = camera->GetScissorRectangle();
        rect.SetHeight(*value);
        camera->SetScissorRectangle(rect);
    }

    CameraScissorRectangleHeightPropertySetter::SharedPointer CameraScissorRectangleHeightPropertySetter::Create()
    {
        return CameraScissorRectangleHeightPropertySetter::SharedPointer(CANDERA_NEW(CameraScissorRectangleHeightPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
