//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BoolUniformPropertySetter.h"

namespace Candera {
    namespace Animation {
        FEATSTD_RTTI_DEFINITION(BoolUniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(BoolVec2UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(BoolVec3UniformPropertySetter, UniformPropertySetter)
        FEATSTD_RTTI_DEFINITION(BoolVec4UniformPropertySetter, UniformPropertySetter)

        BoolUniformPropertySetter::SharedPointer BoolUniformPropertySetter::Create()
        {
            return BoolUniformPropertySetter::SharedPointer(CANDERA_NEW(BoolUniformPropertySetter));
        }

        BoolVec2UniformPropertySetter::SharedPointer BoolVec2UniformPropertySetter::Create()
        {
            return BoolVec2UniformPropertySetter::SharedPointer(CANDERA_NEW(BoolVec2UniformPropertySetter));
        }

        BoolVec3UniformPropertySetter::SharedPointer BoolVec3UniformPropertySetter::Create()
        {
            return BoolVec3UniformPropertySetter::SharedPointer(CANDERA_NEW(BoolVec3UniformPropertySetter));
        }

        BoolVec4UniformPropertySetter::SharedPointer BoolVec4UniformPropertySetter::Create()
        {
            return BoolVec4UniformPropertySetter::SharedPointer(CANDERA_NEW(BoolVec4UniformPropertySetter));
        }
    }
}
