//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BaseCanvasRenderablePropertySetter_H)
#define CANDERA_BaseCanvasRenderablePropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>

namespace Candera {

    class CanvasRenderable;

    namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

    /**
     *  @brief Base class for CanvasRenderable property setters.
     */
        class BaseCanvasRenderablePropertySetter : public AnimationPropertySetter {
            FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(BaseCanvasRenderablePropertySetter);

            FEATSTD_RTTI_DECLARATION();

            /**
            * Constructor.
            */
            BaseCanvasRenderablePropertySetter();

            /**
            * Sets the CanvasRenderable the property setter operates on.
            * @param node The CanvasRenderable object.
            */
            void SetCanvasRenderable(Candera::CanvasRenderable* node) { m_canvas = node; }

            /**
            * Gets the CanvasRenderable the property setter operates on.
            * @return The CanvasRenderable object.
            */
            Candera::CanvasRenderable* GetCanvasRenderable() { return m_canvas; }

            const Candera::CanvasRenderable* GetCanvasRenderable() const { return m_canvas; }

        private:
            Candera::CanvasRenderable* m_canvas;
        };

        /** @} */ // end of AnimationPropertySetters2D
    }// namespace Animation

}// namespace Candera

#endif  // CANDERA_BaseCanvasRenderablePropertySetter_H
