//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BlendEffect2D_H)
    #define CANDERA_BlendEffect2D_H

#include <Candera/Engine2D/Effects/Effect2D.h>

namespace Candera {

/** @addtogroup Effects2D
 *  @{
 */

    /**
     *  @brief Base class for all 2D blend effects.
     */
    class BlendEffect2D : public Effect2D {

        FEATSTD_TYPEDEF_BASE(Effect2D);

        public:
            // overrides Effect2D::GetBlendEffect2D
            virtual BlendEffect2D* GetBlendEffect2D() override { return this; }

            FEATSTD_RTTI_DECLARATION();
    };

 /** @} */ // end of Effects2D

}   // namespace Candera

#endif  // CANDERA_BlendEffect2D_H
