//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TEXTNODERENDERERTOOLS_H)
#define CANDERA_TEXTNODERENDERERTOOLS_H

#include <Candera/Environment.h>

namespace Candera {
    class Image2D;
    class TextNode2D;
    class RenderTarget2D;
    class Matrix3x2;
    class Vector2;
    class Rectangle;

    namespace TextRendering {
        class TextRenderContext;
        class TextCoordinate;
        class TextMeasureContext;
        class LayoutingOptions;
    }

    namespace Internal {
        class TextNodeRendererTools
        {
        public:
            static void RenderImage(Image2D& image,
                                    TextNode2D& textNode,
                                    RenderTarget2D* renderTarget,
                                    const Matrix3x2& localTransform,
                                    const Vector2& offset);

            static bool RenderText(TextRendering::TextRenderContext& context,
                                   const TextNode2D& textNode,
                                   const TextRendering::TextCoordinate &offset);
        };
    }
}   // namespace Candera

#endif  // CANDERA_TEXTNODERENDERERTOOLS_H
