//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "SurfaceTextRenderContext.h"

#include <Candera/Engine2D/Core/TextNodeRenderer/GlyphImageSource2D.h>

namespace Candera {
    using namespace Candera::Internal;

    UInt8* SurfaceGlyphCacheAccess2::Create(const TextRendering::GlyphBitmap &bitmap, UInt8* cacheItem)
    {
        GlyphImageSource2D* imageSource = FeatStd::Internal::PointerToPointer<GlyphImageSource2D*>(cacheItem);
        if (imageSource == 0) {
            imageSource = (CANDERA_NEW(GlyphImageSource2D));
        }

        if (imageSource != 0) {
            imageSource->SetBitmap(bitmap);
        }

        return FeatStd::Internal::PointerToPointer<UInt8*>(imageSource);
    }

    void SurfaceGlyphCacheAccess2::DestroyCacheItem(TextRendering::PixelBuffer buffer)
    {
        if (buffer != 0) {
            CANDERA_DELETE(FeatStd::Internal::PointerToPointer<const GlyphImageSource2D*>(buffer));
        }
    }

    bool SurfaceGlyphCacheAccess2::CheckCacheItem(TextRendering::PixelBuffer buffer)
    {
        const GlyphImageSource2D* imageSource = FeatStd::Internal::PointerToPointer<const GlyphImageSource2D*>(buffer);
        return (imageSource != 0) && (imageSource->HasBitmap());
    }

    /******************************************************************************
    *  GetSurfaceGlyphCacheAccess
    ******************************************************************************/
    SurfaceGlyphCacheAccess2& GlyphCacheTextNodeTextRenderContext::GetSurfaceGlyphCacheAccess()
    {
        return SurfaceGlyphCacheAccess2::Instance();
    }

    void TextNodeTextRenderContext::Blit(Int16 x, Int16 y, const TextRendering::GlyphBitmap &glyph)
    {
        GlyphImageSource2D imageSource;
        imageSource.SetBitmap(glyph);
        BlitImage(x, y, imageSource);
    }

    void GlyphCacheTextNodeTextRenderContext::Blit(Int16 x, Int16 y, const TextRendering::GlyphBitmap &glyph)
    {
        GlyphImageSource2D* imageSource = FeatStd::Internal::PointerToPointer<GlyphImageSource2D*>(const_cast<UInt8*>(glyph.pixels));
        if (imageSource == 0) {
            return;
        }

        BlitImage(x, y, *imageSource);
    }

}   // namespace Candera
