//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ProxyImage2D.h"
#include <Candera/Engine2D/Core/Renderer2D.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <CanderaPlatform/Device/Common/Base/ImageSource2D.h>

namespace Candera {
    using namespace MemoryManagement;
    FEATSTD_RTTI_DEFINITION(ProxyImage2D, Image2D)

ProxyImage2D::ProxyImage2D()
{
}

ProxyImage2D::~ProxyImage2D()
{
    static_cast<void>(Unload(Force));
    m_listener.m_source = 0;
}

SharedPointer<ProxyImage2D> ProxyImage2D::Create()
{
    return SharedPointer<ProxyImage2D>(FEATSTD_NEW(ProxyImage2D));
}

SurfaceHandle ProxyImage2D::Get2DSurfaceHandle() const
{
    return (m_listener.m_source == 0) ? 0 : m_listener.m_source->GetSurfaceHandle();
}

UInt32 ProxyImage2D::GetWidth() const
{
    if ((m_listener.m_source == 0) || (m_listener.m_source->GetSurfaceHandle() == 0)){
        return 0;
    }
    return RenderDevice2D::GetWidth(m_listener.m_source->GetSurfaceHandle());
}

UInt32 ProxyImage2D::GetHeight() const
{
    if ((m_listener.m_source == 0) || (m_listener.m_source->GetSurfaceHandle() == 0)){
        return 0;
    }
    return RenderDevice2D::GetHeight(m_listener.m_source->GetSurfaceHandle());
}


bool ProxyImage2D::Activate(ContextHandle2D context, RenderDevice2D::SurfaceType surfaceType)
{
    if ((m_listener.m_source != 0) && m_listener.m_isSyncEnabled) {
        m_listener.m_source->Sync();
        if (Renderer2D::IsRenderingCamera()) {
            static_cast<void>(Renderer2D::AddRendererListener(&m_listener));
        }
    }

    return Image2D::Activate(context, surfaceType);
}

ProxyImage2D::ProxyImageRendererListener::ProxyImageRendererListener() :
    m_isSyncEnabled(true),
    m_source(0)
{
}

ProxyImage2D::ProxyImageRendererListener::~ProxyImageRendererListener()
{
    // Remove all instances of this listener.
    while (Renderer2D::RemoveRendererListener(this)) {}
    m_source = 0;
}

void ProxyImage2D::ProxyImageRendererListener::OnNodePreRender(RenderNode* /*node*/)
{
}

void ProxyImage2D::ProxyImageRendererListener::OnNodePostRender(RenderNode* /*node*/)
{
}

void ProxyImage2D::ProxyImageRendererListener::OnNodePreRender(const RenderNode* /*node*/, const Matrix3x2* /*modelViewMatrix*/) 
{
}

void ProxyImage2D::ProxyImageRendererListener::OnNodePostRender(const RenderNode* /*node*/, const Matrix3x2* /*modelViewMatrix*/)
{
    if ((m_source != 0) && m_isSyncEnabled) {
        m_source->OnAccess();
    }
    static_cast<void>(Renderer2D::RemoveRendererListener(this));
}

}
