//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_Node2DListener_H)
     #define CANDERA_Node2DListener_H

#include <Candera/EngineBase/Common/ListenerContainer.h>

namespace Candera {

    /** @addtogroup Core2D
    *  @{
    */

    class Node2D;

    /**
    * @brief   A Node2DListener defines hooks that are called when certain Node functions are triggered, e.g. when a Node's transformation changes.
    *          In order to register a Node2DListener to a Node simply derive from Node2DListener and override pure virtual functions with custom code.
    */
    class Node2DListener
    {
    public:
        /**
        * Constructs a Node2DListener object.
        */
        Node2DListener(){}

        /**
        * Destructs a Node2DListener object.
        */
        virtual ~Node2DListener() {}

        /**
        * Is invoked when the transformation of a node is assumed to change.
        * @param node The node to listen to.
        */
        virtual void OnTransformChange(Node2D* node) = 0;

        /**
        * Invoked whenever the node is removed from its parent.
        */
        virtual void OnNodeRemoved(Node2D* parent, Node2D* node) = 0;

        /**
         * Invoked whenever a parent is set for the node.
         */
        virtual void OnNodeAdded(Node2D* parent, Node2D* node) { FEATSTD_UNUSED2(parent, node); }

        /**
         * Invoked whenever a child node is added to the node.
         */
        virtual void OnChildAdded(Node2D* child, Node2D* node) { FEATSTD_UNUSED2(child, node); }

        /**
         * Invoked whenever a child of the node is removed.
         */
        virtual void OnChildRemoved(Node2D* child, Node2D* node) { FEATSTD_UNUSED2(child, node); }

    protected:
        Node2DListener(const Node2DListener&) {};
        Node2DListener& operator=(const Node2DListener&);
    };

    /** @} */ // end of Core2D

} // namespace Candera

#endif// CANDERA_Node2DListener_H



