//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GpuLoadCamera2DRenderStrategy.h"
#include <Candera/Engine2D/Core/Node2D.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageInterface.h>
#include <CanderaPlatform/Device/Common/Base/GpuPerformanceDataProvider.h>

namespace Candera {

using namespace Diagnostics;

FEATSTD_RTTI_DEFINITION(GpuLoadCamera2DRenderStrategy, Camera2DRenderStrategy)

/******************************************************************************
 *  GetRenderPassAction
 ******************************************************************************/
Camera2DRenderStrategy::RenderPassAction GpuLoadCamera2DRenderStrategy::GetRenderPassAction(const Node2D* /*nextNode*/)
{
    GpuPerformanceDataProvider* gpuPerformaceDataProvider = DevicePackageInterface::GetGpuPerformanceDataProvider();
    if (gpuPerformaceDataProvider != 0) {
        static GpuPerformanceData data;
        if (gpuPerformaceDataProvider->GetPerformanceData(data) && (data.gpu.load > m_breakLevel)) {
            return PauseRenderPass;
        }
    }

    return ProceedRenderPass;
}

} // namespace Candera
