//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_NODE2D_CLONE_STRATEGY_H)
#define CANDERA_NODE2D_CLONE_STRATEGY_H

#include <Candera/EngineBase/Cloning/TreeCloneStrategy.h>
#include <Candera/EngineBase/Cloning/SharedObjectCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning2D
 *  @{
 */

// Forward declarations.
class Node2D;
class Effect2D;
class RenderNode;
class TextNode2D;
class CompositeGroup2D;

// Types of strategies for cloning nodes.
typedef TreeCloneStrategy<Node2D, Node2D> Node2DCloneStrategy;
typedef TreeCloneStrategy<CompositeGroup2D, Node2D> CompositeGroup2DCloneStrategy;
typedef TreeCloneStrategy<RenderNode, Node2D> RenderNodeCloneStrategy;
typedef TreeCloneStrategy<TextNode2D, Node2D> TextNode2DCloneStrategy;

// Types of strategies for cloning shared objects.
typedef SharedObjectCloneStrategy<Effect2D, Node2D> Effect2DCloneStrategy;

/** @} */ // end of Cloning2D

} // namespace Candera


#endif  // CANDERA_NODE2D_CLONE_STRATEGY_H
