//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_TREE_CLONER_2D_H)
#define CANDERA_DEEP_TREE_CLONER_2D_H

#include <Candera/Environment.h>
#include <Candera/Engine2D/Cloning/TreeCloner2D.h>
#include <Candera/Engine2D/Cloning/DeepNode2DCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning2D
 *  @{
 */

//forward declarations
class Node2D;

/**
 * @brief This class creates deep clones scene subtrees.
 *
 * It is a convenience wrapper of TreeCloner, that uses a DeepNode2DCloneStrategy.
 * Shared objects are shared between subsequent calls to CreateClone.
 * Destroy cloner, or call Clear to avoid sharing.
 */
class DeepTreeCloner2D {
public:
    /**
     * Constructor.
     */
    DeepTreeCloner2D();

    /**
     * Create a deep clone of the given tree.
     * @param root Root of the source tree.
     * @return a clone of the given tree.
     */
    Node2D* CreateClone(const Node2D& root);

    /**
     * Clear the maps of shared objects.
     */
    void Clear() { m_node2DCloneStrategy.Clear(); }

    /**
     * Retrieve the DeepNode2DCloneStrategy object. This gives the possibility
     * of replacing sub strategies.
     * @return Reference of the inner strategy.
     */
    DeepNode2DCloneStrategy& GetNodeCloneStrategy() { return m_node2DCloneStrategy; }
private:
    FEATSTD_MAKE_CLASS_UNCOPYABLE(DeepTreeCloner2D);

    TreeCloner2D m_treeCloner;
    DeepNode2DCloneStrategy m_node2DCloneStrategy;
};

/** @} */ // end of Cloning2D

} // namespace Candera


#endif  // CANDERA_DEEP_TREE_CLONER_2D_H
