//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepRenderNodeCloneStrategy.h"
#include <Candera/Engine2D/Core/Node2D.h>
#include <Candera/Engine2D/Core/RenderNode.h>
#include <Candera/Engine2D/Cloning/TreeMatch2D.h>

namespace Candera {

void DeepRenderNodeCloneStrategy::Execute(const Pair& current, const RootPair& root)
{
    if ((current.source == 0) || (current.clone == 0)) {
        return;
    }
    // Remove old effects from the clone node.
    UInt8 cloneCount = 0;
    while ((current.clone->GetEffect(cloneCount) != 0) && (cloneCount < 255)) { 
        cloneCount++; 
    }
    while (cloneCount > 0) {
        cloneCount--;
        static_cast<void>(current.clone->RemoveEffect(current.clone->GetEffect(cloneCount)));
    }
    // Add clone effects.
    for (UInt8 i = 0; i < 255; i++) {
        Effect2D::SharedPointer effect2D(current.source->GetEffect(i));
        if (effect2D.PointsToNull()) {
            break;
        }
        static_cast<void>(current.clone->AddEffect(
            m_effect2D.Clone(
                effect2D, 
                root).sharedObject.GetPointerToSharedInstance()));
    }
}


} // namespace Candera
