//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_NODE2D_CLONE_STRATEGY_H)
#define CANDERA_DEEP_NODE2D_CLONE_STRATEGY_H

#include <Candera/Engine2D/Cloning/Node2DCloneStrategy.h>
#include <Candera/Engine2D/Cloning/DeepCompositeGroup2DCloneStrategy.h>
#include <Candera/Engine2D/Cloning/DeepRenderNodeCloneStrategy.h>
#include <Candera/Engine2D/Cloning/DeepTextNode2DCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning2D
 *  @{
 */

//forward declarations
class Node2D;

/**
 * @brief This is the default clone strategy for deep cloning.
 *
 * Cloning respects the following rules:
 *  - all shared resources are deep cloned as long as they are not device
 *      objects; shared resources in the destination are shared in the same
 *      pattern as in the source tree.
 *  - node references are rebuilt as long as source references are found as
 *      descendants of the source root; descendants are mapped to the
 *      destination tree.
 */
class DeepNode2DCloneStrategy : public Node2DCloneStrategy{
public:
    // Implement pure virtual functions of Node2DCloneStrategy.
    virtual void Execute(const Pair& current, const RootPair& root) override;
    virtual void Clear() override;

private:
    DeepRenderNodeCloneStrategy m_renderNode;
    DeepCompositeGroup2DCloneStrategy m_compositeGroup2D;
    DeepTextNode2DCloneStrategy m_textNode2D;
};

/** @} */ // end of Cloning2D

} // namespace Candera


#endif  // CANDERA_DEEP_NODE2D_CLONE_STRATEGY_H
