//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_Transformable2DTranslatePropertySetter_H)
    #define CANDERA_Transformable2DTranslatePropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseTransformable2DPropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /**
     *  @brief Position property setter for x and y coordinate.
     */
    class Transformable2DTranslatePropertySetter : public BaseTransformable2DPropertySetter {

        FEATSTD_TYPEDEF_BASE(BaseTransformable2DPropertySetter);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Transformable2DTranslatePropertySetter);

        FEATSTD_RTTI_DECLARATION();

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         * Sets the new x and y position coordinate values for the transformable object
         * @param value Pointer to float. value[0] for the x and value[1] for the y position of the transformable object
         */
        virtual void Set(const Float* value) override;

    };

    /**
     *  @brief Position property setter only for x coordinate.
     */
    class Transformable2DTranslateXPropertySetter : public BaseTransformable2DPropertySetter {

        typedef BaseTransformable2DPropertySetter Base;

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Transformable2DTranslateXPropertySetter);

        FEATSTD_RTTI_DECLARATION();

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         * Sets the new x position coordinate value for the transformable object
         * @param value Pointer to float value for the local x position of the transformable object.
         */
        virtual void Set(const Float* value) override;

    };

    /**
     *  @brief Position property setter only for y coordinate.
     */
    class Transformable2DTranslateYPropertySetter : public BaseTransformable2DPropertySetter {

        typedef BaseTransformable2DPropertySetter Base;

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Transformable2DTranslateYPropertySetter);

        FEATSTD_RTTI_DECLARATION();

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         * Sets the new y position coordinate value for the transformable object
         * @param value Pointer to float value for the local y position of the transformable object.
         */
        virtual void Set(const Float* value) override;

    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_Transformable2DTranslatePropertySetter_H
