//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Transformable2DTranslatePropertySetter.h"
#include <Candera/Engine2D/Core/Transformable2D.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Transformable2DTranslatePropertySetter, BaseTransformable2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Transformable2DTranslateXPropertySetter, BaseTransformable2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Transformable2DTranslateYPropertySetter, BaseTransformable2DPropertySetter)

    /******************************************************************************
     *  Transformable2DTranslatePropertySetter::Set
     ******************************************************************************/
    void Transformable2DTranslatePropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetPosition(value[0], value[1]);
        }
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DTranslatePropertySetter::SharedPointer Transformable2DTranslatePropertySetter::Create()
    {
        return SharedPointer(CANDERA_NEW(Transformable2DTranslatePropertySetter));
    }

    /******************************************************************************
     *  Transformable2DTranslateXPropertySetter::Set
     ******************************************************************************/
    void Transformable2DTranslateXPropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            Vector2 pos = transformable->GetPosition();
            pos.SetX(*value);
            transformable->SetPosition(pos);
        }
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DTranslateXPropertySetter::SharedPointer Transformable2DTranslateXPropertySetter::Create()
    {
        return SharedPointer(CANDERA_NEW(Transformable2DTranslateXPropertySetter));
    }

    /******************************************************************************
     *  Transformable2DTranslateYPropertySetter::Set
     ******************************************************************************/
    void Transformable2DTranslateYPropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            Vector2 pos = transformable->GetPosition();
            pos.SetY(*value);
            transformable->SetPosition(pos);
        }
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DTranslateYPropertySetter::SharedPointer Transformable2DTranslateYPropertySetter::Create()
    {
        return SharedPointer(CANDERA_NEW(Transformable2DTranslateYPropertySetter));
    }


}}   // namespace Candera { namespace Animation {
