//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Transformable2DRotatePropertySetter.h"
#include <Candera/Engine2D/Core/Transformable2D.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Transformable2DRotatePropertySetter, BaseTransformable2DPropertySetter)

    /******************************************************************************
     *  Transformable2DRotationPropertySetter::Set
     ******************************************************************************/
    void Transformable2DRotatePropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetRotation(*value);
        }
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DRotatePropertySetter::SharedPointer Transformable2DRotatePropertySetter::Create()
    {
        return Transformable2DRotatePropertySetter::SharedPointer(CANDERA_NEW(Transformable2DRotatePropertySetter));
    }

}}   // namespace Candera
