//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Transformable2DRelativeTranslatePropertySetter.h"
#include <Candera/Engine2D/Core/Transformable2D.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Transformable2DRelativeTranslatePropertySetter, BaseTransformable2DRelativePropertySetter)
    FEATSTD_RTTI_DEFINITION(Transformable2DRelativeTranslateXPropertySetter, BaseTransformable2DRelativePropertySetter)
    FEATSTD_RTTI_DEFINITION(Transformable2DRelativeTranslateYPropertySetter, BaseTransformable2DRelativePropertySetter)

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DRelativeTranslatePropertySetter::SharedPointer Transformable2DRelativeTranslatePropertySetter::Create()
    {
        return Transformable2DRelativeTranslatePropertySetter::SharedPointer(CANDERA_NEW(Transformable2DRelativeTranslatePropertySetter));
    }

    void Transformable2DRelativeTranslatePropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetPosition(value[0] + m_position.GetX(), value[1] + m_position.GetY());
        }
    }

    void Transformable2DRelativeTranslatePropertySetter::Initialize()
    {
        m_position = (GetTransformable() != 0) ? GetTransformable()->GetPosition() : Vector2(0.0F, 0.0F);
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DRelativeTranslateXPropertySetter::SharedPointer Transformable2DRelativeTranslateXPropertySetter::Create()
    {
        return Transformable2DRelativeTranslateXPropertySetter::SharedPointer(CANDERA_NEW(Transformable2DRelativeTranslateXPropertySetter));
    }

    void Transformable2DRelativeTranslateXPropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetPosition(value[0] + m_positionX, transformable->GetPosition().GetY());
        }
    }

    void Transformable2DRelativeTranslateXPropertySetter::Initialize()
    {
        m_positionX = (GetTransformable() != 0) ? GetTransformable()->GetPosition().GetX() : Float(0);
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DRelativeTranslateYPropertySetter::SharedPointer Transformable2DRelativeTranslateYPropertySetter::Create()
    {
        return Transformable2DRelativeTranslateYPropertySetter::SharedPointer(CANDERA_NEW(Transformable2DRelativeTranslateYPropertySetter));
    }

    void Transformable2DRelativeTranslateYPropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetPosition(transformable->GetPosition().GetX(), value[0] + m_positionY);
        }
    }

    void Transformable2DRelativeTranslateYPropertySetter::Initialize()
    {
        m_positionY = (GetTransformable() != 0) ? GetTransformable()->GetPosition().GetY() : Float(0);
    }

}}   // namespace Candera { namespace Animation {
