//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_Transformable2DRelativeRotatePropertySetter_H)
    #define CANDERA_Transformable2DRelativeRotatePropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseTransformable2DRelativePropertySetter.h>

namespace Candera { namespace Animation {

    /**
     *  @addtogroup AnimationPropertySetters2D
     *  @{
     */

    /**
     *  @brief Relative rotation AnimationPropertySetter.
     *
     *  The property setter applies a rotation to the associated Transformable2D object, relative to the object rotation
     *   cached at PropertySetter initialization time.
     */
    class Transformable2DRelativeRotatePropertySetter : public BaseTransformable2DRelativePropertySetter {
        FEATSTD_TYPEDEF_BASE(BaseTransformable2DRelativePropertySetter);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Transformable2DRelativeRotatePropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        Transformable2DRelativeRotatePropertySetter():m_rotation(0.0F) {}
        virtual ~Transformable2DRelativeRotatePropertySetter() override {}

        /**
         * Set the relative rotation for the the Transformable2D object.
         *
         * @param value     Pointer to float value that represents the offset that needs to be added to
         *      the cached Transformable2D rotation value.
         */
        virtual void Set(const Float* value) override;

        /**
         * Initialize the PropertySetter.
         *
         * The PropertySetter caches the rotation value of the current associated Transformable2D object, to
         *  be used by future Set calls. If an Transformable2D object is not associated at initialization time,
         *  the cached value is set to a default rotation of 0.0F.
         */
        virtual void Initialize() override;

    private:
        Float m_rotation;

    };

    /**
     * @}
     */ // end of addtogroup AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_Transformable2DRelativeRotatePropertySetter_H
