//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Transformable2DRelativeRotatePropertySetter.h"
#include <Candera/Engine2D/Core/Transformable2D.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Transformable2DRelativeRotatePropertySetter, BaseTransformable2DRelativePropertySetter)

    /******************************************************************************
     *  Create
     ******************************************************************************/
    Transformable2DRelativeRotatePropertySetter::SharedPointer Transformable2DRelativeRotatePropertySetter::Create()
    {
        return Transformable2DRelativeRotatePropertySetter::SharedPointer(CANDERA_NEW(Transformable2DRelativeRotatePropertySetter));
    }

    void Transformable2DRelativeRotatePropertySetter::Set(const Float* value)
    {
        Transformable2D* transformable = GetTransformable();
        if (transformable != 0) {
            transformable->SetRotation(value[0] + m_rotation);
        }
    }

    void Transformable2DRelativeRotatePropertySetter::Initialize()
    {
        m_rotation = (GetTransformable() != 0) ? GetTransformable()->GetRotation() : Float(0);
    }

}}   // namespace Candera { namespace Animation {
