//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SnapToDevicePixelEnabled2DPropertySetter_H)
#define CANDERA_SnapToDevicePixelEnabled2DPropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseNode2DPropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /** 
     * @brief A PropertySetter that sets the "SnapToDevicePixel" property of a Node2D.
     */
    class SnapToDevicePixelEnabled2DPropertySetter : public BaseNode2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(SnapToDevicePixelEnabled2DPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
         * Enable/Disable SnapToDevicePixel property of a RenderNode.
         *
         * SnapToDevicePixel property is enabled if animated float value is > 0.0F, disabled otherwise.
         * @param value Pointer to a Float value.
         */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(BaseNode2DPropertySetter);
    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_SnapToDevicePixelEnabled2DPropertySetter_H
