//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "RenderingEnabledNode2DPropertySetter.h"
#include <Candera/Engine2D/Core/Node2D.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(RenderingEnabledNode2DPropertySetter, BaseNode2DPropertySetter)

    void RenderingEnabledNode2DPropertySetter::Set(const Float* value)
    {
        if ((value == 0) || (GetNode() == 0)) {
            return;
        }

        GetNode()->SetRenderingEnabled(value[0] > 0.5F);
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    RenderingEnabledNode2DPropertySetter::SharedPointer RenderingEnabledNode2DPropertySetter::Create()
    {
        return RenderingEnabledNode2DPropertySetter::SharedPointer(CANDERA_NEW(RenderingEnabledNode2DPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
