//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Node2DClippingRectanglePropertySetter.h"
#include <Candera/Engine2D/Core/RenderNode.h>


namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Node2DClippingRectanglePropertySetter, BaseNode2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Node2DClippingRectangleLeftPropertySetter, BaseNode2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Node2DClippingRectangleTopPropertySetter, BaseNode2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Node2DClippingRectangleWidthPropertySetter, BaseNode2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Node2DClippingRectangleHeightPropertySetter, BaseNode2DPropertySetter)

    /******************************************************************************
    *  Node2DClippingRectanglePropertySetter method definitions
    ******************************************************************************/
    void Node2DClippingRectanglePropertySetter::Set(const Float* value)
    {
#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
        RenderNode* renderNode = Dynamic_Cast<RenderNode*>(GetNode());
        if ((0 == value) || (0 == renderNode)) {
            return;
        }

        renderNode->SetClippingRect(Rectangle(value[0], value[1], value[2], value[3]));
#else
        FEATSTD_UNUSED(value);
#endif
    }
    
    Node2DClippingRectanglePropertySetter::SharedPointer Node2DClippingRectanglePropertySetter::Create()
    {
        return Node2DClippingRectanglePropertySetter::SharedPointer(CANDERA_NEW(Node2DClippingRectanglePropertySetter));
    }

    /******************************************************************************
    *  Node2DClippingRectangleLeftPropertySetter method definitions
    ******************************************************************************/
    void Node2DClippingRectangleLeftPropertySetter::Set(const Float* value)
    {
#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
        RenderNode* renderNode = Dynamic_Cast<RenderNode*>(GetNode());
        if ((0 == value) || (0 == renderNode)) {
            return;
        }

        Rectangle clippingRect = renderNode->GetClippingRect();
        clippingRect.SetLeft(*value);
        renderNode->SetClippingRect(clippingRect);
#else
        FEATSTD_UNUSED(value);
#endif
    }

    Node2DClippingRectangleLeftPropertySetter::SharedPointer Node2DClippingRectangleLeftPropertySetter::Create()
    {
        return Node2DClippingRectangleLeftPropertySetter::SharedPointer(CANDERA_NEW(Node2DClippingRectangleLeftPropertySetter));
    }

    /******************************************************************************
    *  Node2DClippingRectangleTopPropertySetter method definitions
    ******************************************************************************/
    void Node2DClippingRectangleTopPropertySetter::Set(const Float* value)
    {
#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
        RenderNode* renderNode = Dynamic_Cast<RenderNode*>(GetNode());
        if ((0 == value) || (0 == renderNode)) {
            return;
        }

        Rectangle clippingRect = renderNode->GetClippingRect();
        clippingRect.SetTop(*value);
        renderNode->SetClippingRect(clippingRect);
#else
        FEATSTD_UNUSED(value);
#endif
    }

    Node2DClippingRectangleTopPropertySetter::SharedPointer Node2DClippingRectangleTopPropertySetter::Create()
    {
        return Node2DClippingRectangleTopPropertySetter::SharedPointer(CANDERA_NEW(Node2DClippingRectangleTopPropertySetter));
    }

    /******************************************************************************
    *  Node2DClippingRectangleWidthPropertySetter method definitions
    ******************************************************************************/
    void Node2DClippingRectangleWidthPropertySetter::Set(const Float* value)
    {
#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
        RenderNode* renderNode = Dynamic_Cast<RenderNode*>(GetNode());
        if ((0 == value) || (0 == renderNode)) {
            return;
        }

        Rectangle clippingRect = renderNode->GetClippingRect();
        clippingRect.SetWidth(*value);
        renderNode->SetClippingRect(clippingRect);
#else
        FEATSTD_UNUSED(value);
#endif
    }

    Node2DClippingRectangleWidthPropertySetter::SharedPointer Node2DClippingRectangleWidthPropertySetter::Create()
    {
        return Node2DClippingRectangleWidthPropertySetter::SharedPointer(CANDERA_NEW(Node2DClippingRectangleWidthPropertySetter));
    }

    /******************************************************************************
    *  Node2DClippingRectangleHeightPropertySetter method definitions
    ******************************************************************************/
    void Node2DClippingRectangleHeightPropertySetter::Set(const Float* value)
    {
#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
        RenderNode* renderNode = Dynamic_Cast<RenderNode*>(GetNode());
        if ((0 == value) || (0 == renderNode)) {
            return;
        }

        Rectangle clippingRect = renderNode->GetClippingRect();
        clippingRect.SetHeight(*value);
        renderNode->SetClippingRect(clippingRect);
#else
        FEATSTD_UNUSED(value);
#endif
    }

    Node2DClippingRectangleHeightPropertySetter::SharedPointer Node2DClippingRectangleHeightPropertySetter::Create()
    {
        return Node2DClippingRectangleHeightPropertySetter::SharedPointer(CANDERA_NEW(Node2DClippingRectangleHeightPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
