//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Node2DBoundingRectanglePropertySetter.h"
#include <Candera/Engine2D/Core/Node2D.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Node2DBoundingRectanglePropertySetter, BaseNode2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Node2DBoundingRectangleLeftPropertySetter, BaseNode2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Node2DBoundingRectangleTopPropertySetter, BaseNode2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Node2DBoundingRectangleWidthPropertySetter, BaseNode2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Node2DBoundingRectangleHeightPropertySetter, BaseNode2DPropertySetter)

    /******************************************************************************
    *  Node2DBoundingRectanglePropertySetter method definitions
    ******************************************************************************/
    void Node2DBoundingRectanglePropertySetter::Set(const Float* value)
    {
        Node2D* node = GetNode();
        if ((0 == value) || (0 == node)) {
            return;
        }
        node->SetBoundingRectangle(Rectangle(value[0], value[1], value[2], value[3]));
    }
    
    Node2DBoundingRectanglePropertySetter::SharedPointer Node2DBoundingRectanglePropertySetter::Create()
    {
        return Node2DBoundingRectanglePropertySetter::SharedPointer(CANDERA_NEW(Node2DBoundingRectanglePropertySetter));
    }

    /******************************************************************************
    *  Node2DBoundingRectangleLeftPropertySetter method definitions
    ******************************************************************************/
    void Node2DBoundingRectangleLeftPropertySetter::Set(const Float* value)
    {
        Node2D* node = GetNode();
        if ((0 == value) || (0 == node)) {
            return;
        }

        Rectangle rect = node->GetBoundingRectangle();
        rect.SetLeft(*value);
        node->SetBoundingRectangle(rect);
    }

    Node2DBoundingRectangleLeftPropertySetter::SharedPointer Node2DBoundingRectangleLeftPropertySetter::Create()
    {
        return Node2DBoundingRectangleLeftPropertySetter::SharedPointer(CANDERA_NEW(Node2DBoundingRectangleLeftPropertySetter));
    }

    /******************************************************************************
    *  Node2DBoundingRectangleTopPropertySetter method definitions
    ******************************************************************************/
    void Node2DBoundingRectangleTopPropertySetter::Set(const Float* value)
    {
        Node2D* node = GetNode();
        if ((0 == value) || (0 == node)) {
            return;
        }

        Rectangle rect = node->GetBoundingRectangle();
        rect.SetTop(*value);
        node->SetBoundingRectangle(rect);
    }

    Node2DBoundingRectangleTopPropertySetter::SharedPointer Node2DBoundingRectangleTopPropertySetter::Create()
    {
        return Node2DBoundingRectangleTopPropertySetter::SharedPointer(CANDERA_NEW(Node2DBoundingRectangleTopPropertySetter));
    }

    /******************************************************************************
    *  Node2DBoundingRectangleWidthPropertySetter method definitions
    ******************************************************************************/
    void Node2DBoundingRectangleWidthPropertySetter::Set(const Float* value)
    {
        Node2D* node = GetNode();
        if ((0 == value) || (0 == node)) {
            return;
        }

        Rectangle rect = node->GetBoundingRectangle();
        rect.SetWidth(*value);
        node->SetBoundingRectangle(rect);
    }

    Node2DBoundingRectangleWidthPropertySetter::SharedPointer Node2DBoundingRectangleWidthPropertySetter::Create()
    {
        return Node2DBoundingRectangleWidthPropertySetter::SharedPointer(CANDERA_NEW(Node2DBoundingRectangleWidthPropertySetter));
    }

    /******************************************************************************
    *  LayoutMarginsBottomPropertySetter method definitions
    ******************************************************************************/
    void Node2DBoundingRectangleHeightPropertySetter::Set(const Float* value)
    {
        Node2D* node = GetNode();
        if ((0 == value) || (0 == node)) {
            return;
        }

        Rectangle rect = node->GetBoundingRectangle();
        rect.SetHeight(*value);
        node->SetBoundingRectangle(rect);
    }

    Node2DBoundingRectangleHeightPropertySetter::SharedPointer Node2DBoundingRectangleHeightPropertySetter::Create()
    {
        return Node2DBoundingRectangleHeightPropertySetter::SharedPointer(CANDERA_NEW(Node2DBoundingRectangleHeightPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
