//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CameraViewport2DPropertySetter_H)
#define CANDERA_CameraViewport2DPropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseCamera2DPropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /** 
     * @brief A PropertySetter that sets the "Viewport" property of a Camera2D.
     */
    class Camera2DViewportPropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DViewportPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
         * Sets the "Viewport" property of the Camera2D object.
         *
         * @param value - pointer to an array of 4 float values for the Viewport rectangle.
         */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DViewportPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Left value for the "Viewport" property of a Camera2D.
    */
    class Camera2DViewportLeftPropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DViewportLeftPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Left value for the "Viewport" property of a Camera2D.
        *
        * @param value - Left value for the Viewport rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DViewportLeftPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Top value for the "Viewport" property of a Camera2D.
    */
    class Camera2DViewportTopPropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DViewportTopPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Top value for the "Viewport" property of the Camera2D object.
        *
        * @param value - Top value for the Viewport rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DViewportTopPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Width value for the "Viewport" property of a Camera2D.
    */
    class Camera2DViewportWidthPropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DViewportWidthPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets Width value for the "Viewport" property of the Camera2D object.
        *
        * @param value - Width value for the Viewport rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DViewportWidthPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Height value for the "Viewport" property of a Camera2D.
    */
    class Camera2DViewportHeightPropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DViewportHeightPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Height value for the "Viewport" property of the Camera2D object.
        *
        * @param value - Height value for the Viewport rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DViewportHeightPropertySetter);
    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_CameraViewport2DPropertySetter_H
