//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Camera2DViewportPropertySetter.h"
#include <Candera/Engine2D/Core/Camera2D.h>
#include <Candera/Engine2D/Core/RenderNode.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Camera2DViewportPropertySetter, BaseCamera2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Camera2DViewportLeftPropertySetter, BaseCamera2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Camera2DViewportTopPropertySetter, BaseCamera2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Camera2DViewportWidthPropertySetter, BaseCamera2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Camera2DViewportHeightPropertySetter, BaseCamera2DPropertySetter)


    /******************************************************************************
    *  Camera2DViewportPropertySetter method definitions
    ******************************************************************************/
    void Camera2DViewportPropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        camera->SetViewport(Rectangle(value[0], value[1], value[2], value[3]));
    }
    
    Camera2DViewportPropertySetter::SharedPointer Camera2DViewportPropertySetter::Create()
    {
        return Camera2DViewportPropertySetter::SharedPointer(CANDERA_NEW(Camera2DViewportPropertySetter));
    }

    /******************************************************************************
    *  Camera2DViewportLeftPropertySetter method definitions
    ******************************************************************************/
    void Camera2DViewportLeftPropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetViewport();
        rect.SetLeft(*value);
        camera->SetViewport(rect);
    }

    Camera2DViewportLeftPropertySetter::SharedPointer Camera2DViewportLeftPropertySetter::Create()
    {
        return Camera2DViewportLeftPropertySetter::SharedPointer(CANDERA_NEW(Camera2DViewportLeftPropertySetter));
    }

    /******************************************************************************
    *  Camera2DViewportTopPropertySetter method definitions
    ******************************************************************************/
    void Camera2DViewportTopPropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetViewport();
        rect.SetTop(*value);
        camera->SetViewport(rect);
    }

    Camera2DViewportTopPropertySetter::SharedPointer Camera2DViewportTopPropertySetter::Create()
    {
        return Camera2DViewportTopPropertySetter::SharedPointer(CANDERA_NEW(Camera2DViewportTopPropertySetter));
    }

    /******************************************************************************
    *  Camera2DViewportWidthPropertySetter method definitions
    ******************************************************************************/
    void Camera2DViewportWidthPropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetViewport();
        rect.SetWidth(*value);
        camera->SetViewport(rect);
    }

    Camera2DViewportWidthPropertySetter::SharedPointer Camera2DViewportWidthPropertySetter::Create()
    {
        return Camera2DViewportWidthPropertySetter::SharedPointer(CANDERA_NEW(Camera2DViewportWidthPropertySetter));
    }

    /******************************************************************************
    *  Camera2DViewportHeightPropertySetter method definitions
    ******************************************************************************/
    void Camera2DViewportHeightPropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetViewport();
        rect.SetHeight(*value);
        camera->SetViewport(rect);
    }

    Camera2DViewportHeightPropertySetter::SharedPointer Camera2DViewportHeightPropertySetter::Create()
    {
        return Camera2DViewportHeightPropertySetter::SharedPointer(CANDERA_NEW(Camera2DViewportHeightPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
