//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_Camera2DScissorRectanglePropertySetter_H)
#define CANDERA_Camera2DScissorRectanglePropertySetter_H

#include <Candera/Engine2D/AnimationPropertySetters/BaseCamera2DPropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /** 
     * @brief A PropertySetter that sets the "ScissorRectangle" property of a Camera2D.
     */
    class Camera2DScissorRectanglePropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DScissorRectanglePropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
         * Sets the "ScissorRectangle" property of the Camera2D object.
         *
         * @param value - pointer to an array of 4 float values for the ScissorRectangle rectangle.
         */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DScissorRectanglePropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Left value for the "ScissorRectangle" property of a Camera2D.
    */
    class Camera2DScissorRectangleLeftPropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DScissorRectangleLeftPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Left value for the "ScissorRectangle" property of a Camera2D.
        *
        * @param value - Left value for the ScissorRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DScissorRectangleLeftPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Top value for the "ScissorRectangle" property of a Camera2D.
    */
    class Camera2DScissorRectangleTopPropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DScissorRectangleTopPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Top value for the "ScissorRectangle" property of the Camera2D object.
        *
        * @param value - Top value for the ScissorRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DScissorRectangleTopPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Width value for the "ScissorRectangle" property of a Camera2D.
    */
    class Camera2DScissorRectangleWidthPropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DScissorRectangleWidthPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the width value for the "ScissorRectangle" property of the Camera2D object.
        *
        * @param value - Width value for the ScissorRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DScissorRectangleWidthPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the Height value for the "ScissorRectangle" property of a Camera2D.
    */
    class Camera2DScissorRectangleHeightPropertySetter : public BaseCamera2DPropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(Camera2DScissorRectangleHeightPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the Height value for the ScissorRectangle property of the Camera2D object.
        *
        * @param value - Height value for the ScissorRectangle rectangle.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(Camera2DScissorRectangleHeightPropertySetter);
    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_Camera2DScissorRectanglePropertySetter_H
