//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Camera2DScissorRectanglePropertySetter.h"
#include <Candera/Engine2D/Core/Camera2D.h>
#include <Candera/Engine2D/Core/RenderNode.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(Camera2DScissorRectanglePropertySetter, BaseCamera2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Camera2DScissorRectangleLeftPropertySetter, BaseCamera2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Camera2DScissorRectangleTopPropertySetter, BaseCamera2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Camera2DScissorRectangleWidthPropertySetter, BaseCamera2DPropertySetter)
    FEATSTD_RTTI_DEFINITION(Camera2DScissorRectangleHeightPropertySetter, BaseCamera2DPropertySetter)


    /******************************************************************************
    *  Camera2DScissorRectanglePropertySetter method definitions
    ******************************************************************************/
    void Camera2DScissorRectanglePropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }
        camera->SetScissorRectangle(Rectangle(value[0], value[1], value[2], value[3]));
    }
    
    Camera2DScissorRectanglePropertySetter::SharedPointer Camera2DScissorRectanglePropertySetter::Create()
    {
        return Camera2DScissorRectanglePropertySetter::SharedPointer(CANDERA_NEW(Camera2DScissorRectanglePropertySetter));
    }

    /******************************************************************************
    *  Camera2DScissorRectangleLeftPropertySetter method definitions
    ******************************************************************************/
    void Camera2DScissorRectangleLeftPropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }

        Rectangle rect = camera->GetScissorRectangle();
        rect.SetLeft(*value);
        camera->SetScissorRectangle(rect);
    }

    Camera2DScissorRectangleLeftPropertySetter::SharedPointer Camera2DScissorRectangleLeftPropertySetter::Create()
    {
        return Camera2DScissorRectangleLeftPropertySetter::SharedPointer(CANDERA_NEW(Camera2DScissorRectangleLeftPropertySetter));
    }

    /******************************************************************************
    *  Camera2DScissorRectangleTopPropertySetter method definitions
    ******************************************************************************/
    void Camera2DScissorRectangleTopPropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }
        Rectangle rect = camera->GetScissorRectangle();
        rect.SetTop(*value);
        camera->SetScissorRectangle(rect);
    }

    Camera2DScissorRectangleTopPropertySetter::SharedPointer Camera2DScissorRectangleTopPropertySetter::Create()
    {
        return Camera2DScissorRectangleTopPropertySetter::SharedPointer(CANDERA_NEW(Camera2DScissorRectangleTopPropertySetter));
    }

    /******************************************************************************
    *  Camera2DScissorRectangleWidthPropertySetter method definitions
    ******************************************************************************/
    void Camera2DScissorRectangleWidthPropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }
        Rectangle rect = camera->GetScissorRectangle();
        rect.SetWidth(*value);
        camera->SetScissorRectangle(rect);
    }

    Camera2DScissorRectangleWidthPropertySetter::SharedPointer Camera2DScissorRectangleWidthPropertySetter::Create()
    {
        return Camera2DScissorRectangleWidthPropertySetter::SharedPointer(CANDERA_NEW(Camera2DScissorRectangleWidthPropertySetter));
    }

    /******************************************************************************
    *  Camera2DScissorRectangleHeightPropertySetter method definitions
    ******************************************************************************/
    void Camera2DScissorRectangleHeightPropertySetter::Set(const Float* value)
    {
        Camera2D* camera = GetCamera();
        if ((0 == value) || (0 == camera)) {
            return;
        }
        Rectangle rect = camera->GetScissorRectangle();
        rect.SetHeight(*value);
        camera->SetScissorRectangle(rect);
    }

    Camera2DScissorRectangleHeightPropertySetter::SharedPointer Camera2DScissorRectangleHeightPropertySetter::Create()
    {
        return Camera2DScissorRectangleHeightPropertySetter::SharedPointer(CANDERA_NEW(Camera2DScissorRectangleHeightPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
