//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BaseTransformable2DPropertySetter_H)
    #define CANDERA_BaseTransformable2DPropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>

namespace Candera { 
    
    class Transformable2D;

    namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /**
     *  @brief Base class for Transformable2D property setters.
     */
    class BaseTransformable2DPropertySetter : public AnimationPropertySetter {
        FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(BaseTransformable2DPropertySetter);

        FEATSTD_RTTI_DECLARATION();

        /**
         * Constructor.
         */
        BaseTransformable2DPropertySetter() :
            m_transformable(0)
        {
        }

        /**
         * Sets the transformable object the property setter operates on.
         * @param transformable The transformable object
         */
        void SetTransformable(Transformable2D* transformable) { m_transformable = transformable; }
        /**
         * Gets the transformable object the property setter operates on.
         * @return The transformable object
         */
        Transformable2D* GetTransformable() { return m_transformable; }

    private:
        Transformable2D* m_transformable;
    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

 }   // namespace Candera

#endif  // CANDERA_BaseTransformable2DPropertySetter_H
