//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef eglconfig_h
#define eglconfig_h

/*
 * Include wayland egl header, in order to define necessary compile switches.
 */
#include <wayland-egl.h>
#define EGL_API_WAYLAND 1

//Enable EGL extensions.
#define EGL_EGLEXT_PROTOTYPES 1

/*
 * This header file allows a platform to disable extensions listed in eglext.h,
 * by simply placing a #define macro with extension name and with the distinct value 0.
 * Extension name strings are listed at http://www.khronos.org/registry/egl/.
 * For example, if you want to disable the extension EGL_NV_depth_nonlinear for programs that are
 * compiled against "eglext.h" header, simply place the macro definition
 * "#define EGL_NV_depth_nonlinear 0" below. The include guard in file "eglext.h" prevents then the
 * definiton of EGL_NV_depth_nonlinear with value 1 and related tokens like EGL_DEPTH_ENCODING_NV.
 *
 * Note: This file must be included before "eglext.h" in order to take affect.
 *
 * To test within application code against an extension, see following example:
 * #if EGL_NV_depth_nonlinear
 *      // process code with extension enabled.
 * #else
 *      // process code with extension disabled.
 * #endif
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Place #define statements as needed below this comment to disable certain extensions listed in gl2ext.h
 * Example: #define EGL_NV_depth_nonlinear 0  // Each define MUST HAVE value "0".
 */

#undef EGL_NV_depth_nonlinear
#define EGL_NV_depth_nonlinear              0xFFffFFff

#undef EGL_KHR_stream_fifo
#define EGL_KHR_stream_fifo                 0xFFffFFff

#undef EGL_KHR_fence_sync
#define EGL_KHR_fence_sync                  0

#undef EGL_DEPTH_ENCODING_NONE_NV
#define EGL_DEPTH_ENCODING_NONE_NV          EGL_DONT_CARE

#undef EGL_DEPTH_ENCODING_NONLINEAR_NV
#define EGL_DEPTH_ENCODING_NONLINEAR_NV     EGL_DONT_CARE

#undef EGL_DEPTH_ENCODING_NV
#define EGL_DEPTH_ENCODING_NV               0xFFffFFff


#undef EGL_NV_coverage_sample
#define EGL_NV_coverage_sample              0

#undef EGL_COVERAGE_BUFFERS_NV
#define EGL_COVERAGE_BUFFERS_NV             0xFFffFFff

#undef EGL_COVERAGE_SAMPLES_NV
#define EGL_COVERAGE_SAMPLES_NV             0xFFffFFff


#ifdef __cplusplus
}
#endif

#endif  // eglconfig_h
