/******************************************************************************
*
* FILE:          TunerInfoDBusHandler.c
*   
* PROJECT:       Generic gateway
*
* DESCRIPTION:   Dbus server implemenatation for TunerInfo
*
* AUTHOR:        BCP9KOR
*
* COPYRIGHT:     (c) 2016 Robert Bosch GmbH, Hildesheim
*
*****************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#include <gio/gio.h>
#include <stdlib.h>


#include "TunerInfoDBusHandler.h"
#include "AutomDBusServer.h"
#include "Tuner_GenericClientInterface.h"
#include "ap-tuner-error-enums.h"
#include "ap-tuner-enums.h"

//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_IMPORT_CONTEXT(AGW_Tuner);

GDBusMethodInvocation *g_invocation_get_station_list = NULL;


/******************************************************************************
 * Function:     handle_get_station_list_for_band
 * Description:  Handler for get station list for band method
 * Parameters:   proxy object pointer, invocation pointer, band
 * Return:       bool
 *****************************************************************************/
gboolean handle_get_station_list_for_band (TunerInfo *object,
                                           GDBusMethodInvocation *invocation,
                                           guchar arg_band)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+handle_get_station_list_for_band with band:"),
            DLT_INT(arg_band));

    g_invocation_get_station_list =  g_object_ref(invocation);
    if(arg_band == AP_TUNER_BAND_DAB)
    {
        bGetDABStationList();
    }
    else
    {
        vRequestAvblStn(arg_band);
    }
    return TRUE;
}                                           

/******************************************************************************
 * Function:     bSendGetStationListResult
 * Description:  Sends method result of GetStationList
 * Parameters:   Gvariant Station List
 * Return:       bool
 *****************************************************************************/
gboolean bSendGetStationListResult(GVariant* arg_stataionList)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+bSendGetStationListResult"));
    TunerInfo* poTunerInfoProxyObj = poGetTunerInfoProxyObj();
    if(poTunerInfoProxyObj == NULL || g_invocation_get_station_list == NULL)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("Proxy object or invocation pointer is null"));
        g_clear_object (&g_invocation_get_station_list);	
        return FALSE;
    }

    if(arg_stataionList == NULL)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("+bSendGetStationListResult"));

        g_dbus_method_invocation_return_error (g_invocation_get_station_list,
                                               AP_TUNER_ERROR,
                                               AP_TUNER_ERROR_UNKOWN,
                                               "ERROR in get station list");
	    g_clear_object (&g_invocation_get_station_list);
        return TRUE;

    }

    tuner_info_complete_get_station_list_for_band (
                poTunerInfoProxyObj,
                g_invocation_get_station_list,
                arg_stataionList);

	g_clear_object (&g_invocation_get_station_list);
    return TRUE;
}

/******************************************************************************
 * Function:     bSendStationListUpdate
 * Description:  Emits station list changed signal
 * Parameters:   band, Gvariant Station List
 * Return:       bool
 *****************************************************************************/
gboolean bSendStationListUpdate(ApTunerBand arg_band,GVariant* arg_stataionList)
{


    TunerInfo* poTunerInfoProxyObj = poGetTunerInfoProxyObj();
    if(poTunerInfoProxyObj == NULL || arg_stataionList == NULL)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("Proxy object or arg_stataionList pointer is null"));
        return FALSE;
    }
    else
    {
        tuner_info_emit_station_list_changed(poTunerInfoProxyObj,
                                             arg_band,arg_stataionList);
    }

    return TRUE;
}

/******************************************************************************
 * Function:     vSetStationInfo
 * Description:  Updates station info property
 * Parameters:   Gvariant Station Info
 * Return:       void
 *****************************************************************************/
void vSetStationInfo(GVariant *stationInfo)
{
    TunerInfo* poTunerInfoProxyObj = poGetTunerInfoProxyObj();
    if(poTunerInfoProxyObj == NULL || stationInfo == NULL)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,
                DLT_STRING("Proxy object or stationInfo pointer is null"));
        return;
    }
    else
    {
        tuner_info_set_station_info(poTunerInfoProxyObj,
                                    stationInfo);
    }

}

/******************************************************************************
 * Function:     vSetConfigSettingsProp
 * Description:  Updates configuration settings property
 * Parameters:   Gvariant configuration settings
 * Return:       void
 *****************************************************************************/
void vSetConfigSettingsProp(GVariant* arg_ConfigSettings)
{

    #if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vSetConfigSettingsProp"));
    #endif

    TunerInfo* poTunerInfoProxyObj = poGetTunerInfoProxyObj();
    if(poTunerInfoProxyObj == NULL || arg_ConfigSettings == NULL)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                    "Proxy object or arg_ConfigSettings pointer is null"));
        return;
    }
    else
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vSetConfigSettingsProp"));
        tuner_info_set_configuration_settings (poTunerInfoProxyObj,
                                               arg_ConfigSettings);
    }

}

/******************************************************************************
 * Function:     vSetPresetListProp
 * Description:  Upgates preset list property
 * Parameters:   Gvariant preset List
 * Return:       void
 *****************************************************************************/
void vSetPresetListProp(GVariant*  arg_PresetList)
{

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vSetPresetListProp"));

    TunerInfo* poTunerInfoProxyObj = poGetTunerInfoProxyObj();
    if(poTunerInfoProxyObj == NULL || arg_PresetList == NULL)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                    "Proxy object or arg_PresetList pointer is null"));
        return;
    }
    else
    {
        tuner_info_set_preset_list(poTunerInfoProxyObj,
                                   arg_PresetList);
    }

}

/******************************************************************************
 * Function:     vSendGetStationListError
 * Description:  Sends method error for get station list
 * Parameters:   Error enum, char*
 * Return:       void
 *****************************************************************************/
void vSendGetStationListError(APTunerError eError, char* sErrMsg)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vSendGetStationListError"));
    if(g_invocation_get_station_list == NULL)
    {
        DLT_LOG(AGW_Tuner,DLT_LOG_ERROR,DLT_STRING(
                    "Invocation pointer is null"));
        return;
    }
    else
    {
        if(sErrMsg == NULL)
        {
            g_dbus_method_invocation_return_error (
                        g_invocation_get_station_list,
                        AP_TUNER_ERROR,
                        (int)eError,
                        "ERROR in get station list");
        }
        else
        {
            g_dbus_method_invocation_return_error (
                        g_invocation_get_station_list,
                        AP_TUNER_ERROR,
                        (int)eError,
                        sErrMsg);
        }
		
		g_clear_object (&g_invocation_get_station_list);

    }

}               
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC