/******************************************************************************
*
* FILE:          TunerDataHandler.cpp
* SW-COMPONENT:  Tuner Gateway
* PROJECT:       Generic Gateway
* DESCRIPTION:   Data handling for Tuner
******************************************************************************/

#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#include "TunerDataHandler.h"
#include "Tuner_GenericClientInterface.h"
#include "FC_Gateway_TunerClientHandler.h"

//Dlt
#include "dlt/dlt.h"
//Dlt Context
DLT_IMPORT_CONTEXT(AGW_Tuner);

tclConfigSettings* 
tclConfigSettings::m_poConfigSettings = NULL;

/******************************************************************************
 * Function:     getInstance
 * Description:  singleton
 * Parameters:   void
 * Return:       tclConfigSettings instance
 *****************************************************************************/

tclConfigSettings* tclConfigSettings::getInstance()
{

    if(m_poConfigSettings == NULL)
    {
        m_poConfigSettings = new tclConfigSettings();
    }

    return m_poConfigSettings;
}

/******************************************************************************
 * Function:     tclConfigSettings
 * Description:  Constructor
 * Parameters:   Instance of main app
 * Return:       NA
 *****************************************************************************/

tclConfigSettings::tclConfigSettings()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("tclConfigSettings:"),
            DLT_STRING( __FUNCTION__));

    bAMActive = FALSE;
    bHDRadio = FALSE;
    bRegion = FALSE;
    bTA = FALSE;
    bSeamlessSwitching = FALSE;
    bTransportAnnouncement = FALSE;
    bWarningAnnouncement = FALSE;
    bNewsAnnouncement = FALSE;
    bWeatherAnnouncement = FALSE;
    bEventAnnouncement = FALSE;
    bMusicalEventAnnouncement = FALSE;
    bRadioInfoAnnouncement = FALSE;
    bSportAnnouncement = FALSE;
    bFinanceAnnouncement = FALSE;
    bDABAvailability = FALSE;
}

/******************************************************************************
 * Function:     ~tclConfigSettings
 * Description:  Destructor
 * Parameters:   void
 * Return:       NA
 *****************************************************************************/

tclConfigSettings::~tclConfigSettings()
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("tclConfigSettings Destructor :"),
            DLT_STRING(__FUNCTION__));

    if(m_poConfigSettings!= NULL)
    {
        delete m_poConfigSettings;
        m_poConfigSettings = NULL;
    }
}

/******************************************************************************
 * Function:     Get configuration settings
 * Description:  getter function
 * Parameters:   void
 * Return:       bool
 *****************************************************************************/
bool tclConfigSettings::bGetAMActiveStatus() const
{
    return bAMActive;
}

bool tclConfigSettings::bGetHDRadioStatus() const
{
    return bHDRadio;
}

bool tclConfigSettings::bGetRegionStatus() const
{
    return bRegion;
}

bool tclConfigSettings::bGetTAStatus() const
{
    return bTA;
}

bool tclConfigSettings::bGetSeamlessSwitchingStatus() const
{
    return bSeamlessSwitching;
}

bool tclConfigSettings::bGetTransportAnnouncementStatus() const
{
    return bTransportAnnouncement;
}

bool tclConfigSettings::bGetWarningAnnouncementStatus() const
{
    return bWarningAnnouncement;
}

bool tclConfigSettings::bGetNewsAnnouncementStatus() const
{
    return bNewsAnnouncement;
}

bool tclConfigSettings::bGetWeatherAnnouncementStatus() const
{
    return bWeatherAnnouncement;
}

bool tclConfigSettings::bGetEventAnnouncementStatus() const
{
    return bEventAnnouncement;
}

bool tclConfigSettings::bGetMusicalEventAnnouncementStatus() const
{
    return bMusicalEventAnnouncement;
}

bool tclConfigSettings::bGeRadioInfoAnnouncementStatus() const
{
    return bRadioInfoAnnouncement;
}

bool tclConfigSettings::bGetSportAnnouncementStatus() const
{
    return bSportAnnouncement;
}

bool tclConfigSettings::bGetFinanceAnnouncementStatus() const
{
    return bFinanceAnnouncement;
}

bool tclConfigSettings::bGetDABAvailabilityStatus() const
{
    return bDABAvailability;
}


/******************************************************************************
 * Function:     Set configuration settings
 * Description:  Setter functions
 * Parameters:   bool
 * Return:       void
 *****************************************************************************/
void tclConfigSettings::vSetAMActive(bool bStatus)
{
    bAMActive = bStatus;
}

void tclConfigSettings::vSetHDRadio(bool bStatus)
{
    bHDRadio = bStatus;
}

void tclConfigSettings::vSetRegion(bool bStatus)
{
    bRegion = bStatus;
}

void tclConfigSettings::vSetTA(bool bStatus)
{
    bTA = bStatus;
}

void tclConfigSettings::vSetSeamlessSwitching(bool bStatus)
{
    bSeamlessSwitching = bStatus;
}

void tclConfigSettings::vSetTransportAnnouncement(bool bStatus)
{
    bTransportAnnouncement = bStatus;
}

void tclConfigSettings::vSetWarningAnnouncement(bool bStatus)
{
    bWarningAnnouncement = bStatus;
}

void tclConfigSettings::vSetNewsAnnouncement(bool bStatus)
{
    bNewsAnnouncement = bStatus;
}

void tclConfigSettings::vSetWeatherAnnouncement(bool bStatus)
{
    bWeatherAnnouncement = bStatus;
}

void tclConfigSettings::vSetEventAnnouncement(bool bStatus)
{
    bEventAnnouncement = bStatus;
}

void tclConfigSettings::vSetMusicalEventAnnouncement(bool bStatus)
{
    bMusicalEventAnnouncement = bStatus;
}

void tclConfigSettings::vSetRadioInfoAnnouncement(bool bStatus)
{
    bRadioInfoAnnouncement = bStatus;
}

void tclConfigSettings::vSetSportAnnouncement(bool bStatus)
{
    bSportAnnouncement = bStatus;
}

void tclConfigSettings::vSetFinanceAnnouncement(bool bStatus)
{
    bFinanceAnnouncement = bStatus;
}

void tclConfigSettings::vSetDABAvailability(bool bStatus)
{
    bDABAvailability = bStatus;
}

/******************************************************************************
 * Function:     vUpdatePresetListDataHandler
 * Description:  Handles conversion from C++ data type to GVariant
                 and sends to DBus hanler for update Preset List Property.
 * Parameters:   vector of preset elemets.
 * Return:       void
 *****************************************************************************/
void vUpdatePresetListDataHandler(std::vector<stPresetElement> presetList)
{
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vUpdatePresetListDataHandler"));
    GVariant* l_PresetList = NULL;

    GVariantBuilder builder;
    g_variant_builder_init (&builder, G_VARIANT_TYPE ("a(yyus)"));

    for(std::vector<stPresetElement>::iterator iIterator = presetList.begin();
        iIterator != presetList.end(); ++iIterator)
    {
        g_variant_builder_add (&builder,"(yyus)",
                               iIterator->band,
                               iIterator->index,
                               iIterator->frequency,
                               iIterator->stationName.c_str());
    }

    l_PresetList = g_variant_builder_end (&builder);
	GVariant* l_PresetListRef = g_variant_ref_sink(l_PresetList);
    vSetPresetListProp(l_PresetListRef);
	g_variant_unref(l_PresetListRef);

}

/******************************************************************************
 * Function:     vUpdateStationInfo
 * Description:  Handles conversion from C++ data type to GVariant
                 and sends to DBus hanler for update station info Property.
 * Parameters:   stStationInfo.
 * Return:       void
 *****************************************************************************/
void vUpdateStationInfo(stStationInfo arg_stationInfo)
{
    //DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vUpdateStationInfo"));

    GVariant* l_StationInfo = NULL;
    GVariantBuilder builder;
    g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));

    g_variant_builder_add (&builder, "{sv}", "band",
                           g_variant_new_byte(arg_stationInfo.band));
    g_variant_builder_add (&builder, "{sv}", "frequency",
                           g_variant_new_uint32(arg_stationInfo.u32Frequency));
    g_variant_builder_add (&builder, "{sv}", "programID",
                           g_variant_new_uint16(arg_stationInfo.programID));
    g_variant_builder_add (&builder, "{sv}", "fieldStrength",
                           g_variant_new_byte(arg_stationInfo.fieldStrength));
    g_variant_builder_add (&builder, "{sv}", "stationName",
                           g_variant_new_string(
                               arg_stationInfo.stationName.c_str()));
    g_variant_builder_add (&builder, "{sv}", "stationText",
                           g_variant_new_string(
                               arg_stationInfo.stationText.c_str()));
    g_variant_builder_add (&builder, "{sv}", "presetListID",
                           g_variant_new_uint16(arg_stationInfo.presetListID));
    g_variant_builder_add (&builder, "{sv}", "programType",
                           g_variant_new_byte(arg_stationInfo.programType));

    l_StationInfo = g_variant_builder_end (&builder);

    GVariant* l_StationInfoRef = g_variant_ref_sink(l_StationInfo);
    vSetStationInfo(l_StationInfoRef);
    g_variant_unref(l_StationInfoRef);
}

/******************************************************************************
 * Function:     vUpdateConfigSettings
 * Description:  Handles conversion from C++ data type to GVariant
                 and sends to DBus hanler for update station info Property.
 * Parameters:   tclConfigSettings*
 * Return:       void
 *****************************************************************************/
void vUpdateConfigSettings(tclConfigSettings* arg_config_settings)
{
    #if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,DLT_STRING("+vUpdateConfigSettings"));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:AMActive value "),
            DLT_INT(arg_config_settings->bGetAMActiveStatus()));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:HDRadio value "),
            DLT_INT(arg_config_settings->bGetHDRadioStatus()));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:Region value "),
            DLT_INT(arg_config_settings->bGetRegionStatus()));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:TA value "),
            DLT_INT(arg_config_settings->bGetTAStatus()));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:SeamlessSwitching value "),
            DLT_INT(arg_config_settings->bGetSeamlessSwitchingStatus()));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:TransportAnnouncement value "),
            DLT_INT(arg_config_settings->bGetTransportAnnouncementStatus()));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:WarningAnnouncement value "),
            DLT_INT( arg_config_settings->bGetWarningAnnouncementStatus()));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:NewsAnnouncement value "),
            DLT_INT( arg_config_settings->bGetNewsAnnouncementStatus()));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:WeatherAnnouncement value ")
            ,DLT_INT( arg_config_settings->bGetWeatherAnnouncementStatus()));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:EventAnnouncement value "),
            DLT_INT( arg_config_settings->bGetEventAnnouncementStatus()));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:MusicalEventAnnouncement value "),
            DLT_INT(arg_config_settings->bGetMusicalEventAnnouncementStatus()));

    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:RadioInfoAnnouncement value "),
            DLT_INT(arg_config_settings->bGeRadioInfoAnnouncementStatus()));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:SportAnnouncement value "),
            DLT_INT(arg_config_settings->bGetSportAnnouncementStatus()));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:FinanceAnnouncement value "),
            DLT_INT(arg_config_settings->bGetFinanceAnnouncementStatus()));
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("vUpdateConfigSettings:DABAvailability value "),
            DLT_INT( arg_config_settings->bGetDABAvailabilityStatus()));

    #endif
    GVariant* l_ConfigSettings = NULL;
    GVariantBuilder builder;
	g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));


    g_variant_builder_add (&builder, "{sv}", "AMActive",
                           g_variant_new_boolean (
                               arg_config_settings->bGetAMActiveStatus()));

    g_variant_builder_add (&builder, "{sv}", "HDRadio",
                           g_variant_new_boolean(
                               arg_config_settings->bGetHDRadioStatus()));

    g_variant_builder_add (&builder, "{sv}", "Region",
                           g_variant_new_boolean(
                               arg_config_settings->bGetRegionStatus()));

    g_variant_builder_add (&builder, "{sv}", "TA",
                           g_variant_new_boolean(
                               arg_config_settings->bGetTAStatus()));

    g_variant_builder_add (&builder, "{sv}", "SeamlessSwitching",
                           g_variant_new_boolean(
                               arg_config_settings->bGetSeamlessSwitchingStatus()));

    g_variant_builder_add (&builder, "{sv}", "TransportAnnouncement",
                           g_variant_new_boolean(
                               arg_config_settings->bGetTransportAnnouncementStatus()));


    g_variant_builder_add (&builder, "{sv}", "WarningAnnouncement",
                           g_variant_new_boolean(
                               arg_config_settings->bGetWarningAnnouncementStatus()));


    g_variant_builder_add (&builder, "{sv}", "NewsAnnouncement",
                           g_variant_new_boolean(
                               arg_config_settings->bGetNewsAnnouncementStatus()));

    g_variant_builder_add (&builder, "{sv}", "WeatherAnnouncement",
                           g_variant_new_boolean(
                               arg_config_settings->bGetWeatherAnnouncementStatus()));

    g_variant_builder_add (&builder, "{sv}", "EventAnnouncement",
                           g_variant_new_boolean(
                               arg_config_settings->bGetEventAnnouncementStatus()));


    g_variant_builder_add (&builder, "{sv}", "MusicalEventAnnouncement",
                           g_variant_new_boolean(
                               arg_config_settings->bGetMusicalEventAnnouncementStatus()));

    g_variant_builder_add (&builder, "{sv}", "RadioInfoAnnouncement",
                           g_variant_new_boolean(
                               arg_config_settings->bGeRadioInfoAnnouncementStatus()));

    g_variant_builder_add (&builder, "{sv}", "SportAnnouncement",
                           g_variant_new_boolean(
                               arg_config_settings->bGetSportAnnouncementStatus()));

    g_variant_builder_add (&builder, "{sv}", "FinanceAnnouncement",
                           g_variant_new_boolean(
                               arg_config_settings->bGetFinanceAnnouncementStatus()));

    g_variant_builder_add (&builder, "{sv}", "DABAvailability",
                           g_variant_new_boolean(
                               arg_config_settings->bGetDABAvailabilityStatus()));

    l_ConfigSettings = g_variant_builder_end (&builder);
    
    GVariant* l_ConfigSettingsRef = g_variant_ref_sink(l_ConfigSettings);
    vSetConfigSettingsProp(l_ConfigSettingsRef);
    g_variant_unref(l_ConfigSettingsRef);
}

/******************************************************************************
 * Function:     vHandleGetStationListDataHandler
 * Description:  Handles conversion from C++ data type to GVariant
                 and sends to DBus hanler for get station list method.
 * Parameters:   stationList vector
 * Return:       void
 *****************************************************************************/
void vHandleGetStationListDataHandler(std::vector<unsigned int> stationList)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+vHandleGetStationListDataHandler"));
#endif
    GVariant* l_StationList = NULL;
    GVariantBuilder builder;
	g_variant_builder_init (&builder, G_VARIANT_TYPE ("a(u)"));

    for(std::vector<unsigned int>::iterator iIterator = stationList.begin();
        iIterator != stationList.end(); ++iIterator)
    {
#if 0
        DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
                DLT_STRING("Element iterator:"),DLT_INT(*iIterator));
#endif
        g_variant_builder_add (&builder,"(u)",*iIterator);
    }

    l_StationList = g_variant_builder_end (&builder);

    GVariant* l_StationListRef = g_variant_ref_sink(l_StationList);
    bSendGetStationListResult(l_StationListRef);
    if(l_StationList != NULL)
    {
        g_variant_unref(l_StationListRef);
        l_StationListRef = NULL;
    }
}

/******************************************************************************
 * Function:     vHandleUpdateStationListDataHandler
 * Description:  Handles conversion from C++ data type to GVariant
                 and sends to DBus hanler for update station info Property.
 * Parameters:   band, stationList vector
 * Return:       void
 *****************************************************************************/
void vHandleUpdateStationListDataHandler(ApTunerBand eBand, 
                                         std::vector<unsigned int> stationList)
{
#if 0
    DLT_LOG(AGW_Tuner,DLT_LOG_INFO,
            DLT_STRING("+vHandleUpdateStationListDataHandler"));
#endif
    GVariant* l_StationList = NULL;
    GVariantBuilder builder;
	g_variant_builder_init ( &builder, G_VARIANT_TYPE ("a(u)"));
    for(std::vector<unsigned int>::iterator iIterator = stationList.begin();
        iIterator != stationList.end(); ++iIterator)
    {
        g_variant_builder_add (&builder,"(u)",*iIterator);
    }

    l_StationList = g_variant_builder_end (&builder);

    GVariant* l_StationListRef = g_variant_ref_sink(l_StationList);
    bSendStationListUpdate(eBand, l_StationListRef);
    g_variant_unref(l_StationListRef);
}
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC